package ru.yandex.intranet.d.web.model.units.front;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * PluralForm
 *
 * @author Denis Blokhin <denblo@yandex-team.ru>
 */
public enum PluralFormDto {
    ONE("one"),
    SOME("some"),
    MANY("many"),
    NONE("none");

    private static final Map<String, PluralFormDto> DTO_BY_KEY = Arrays.stream(values())
            .collect(Collectors.toMap(PluralFormDto::getKey, Function.identity()));

    private final String key;

    PluralFormDto(String key) {
        this.key = key;
    }

    public String getKey() {
        return key;
    }

    @JsonValue
    public String toJsonValue() {
        return key;
    }

    @JsonCreator
    public static PluralFormDto fromJsonValue(String value) {
        return DTO_BY_KEY.get(value);
    }
}
