package ru.yandex.intranet.d.web.security;

import java.security.Principal;

import net.devh.boot.grpc.server.security.interceptors.AuthenticatingServerInterceptor;
import org.springframework.security.core.Authentication;

import ru.yandex.intranet.d.web.security.model.YaAuthenticationToken;
import ru.yandex.intranet.d.web.security.model.YaUserDetails;

/**
 * Utility methods to work with Principal.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class Auth {

    private Auth() {
    }

    public static YaAuthenticationToken cast(Principal principal) {
        return (YaAuthenticationToken) principal;
    }

    public static YaUserDetails details(Principal principal) {
        return (YaUserDetails) ((YaAuthenticationToken) principal).getPrincipal();
    }

    public static YaUserDetails grpcUser() {
        Authentication authentication = AuthenticatingServerInterceptor.SECURITY_CONTEXT_KEY.get().getAuthentication();
        return (YaUserDetails) authentication.getPrincipal();
    }

}
