package ru.yandex.intranet.d.web.security;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.config.annotation.method.configuration.EnableReactiveMethodSecurity;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.authentication.AuthenticationWebFilter;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.authentication.ServerAuthenticationEntryPointFailureHandler;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.web.server.session.WebSessionManager;

import ru.yandex.intranet.d.web.security.impl.NoOpWebSessionManager;
import ru.yandex.intranet.d.web.security.impl.YaServerAccessDeniedHandler;
import ru.yandex.intranet.d.web.security.impl.YaServerAuthenticationEntryPoint;

/**
 * Web security configuration.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@EnableWebFluxSecurity
@EnableReactiveMethodSecurity
public class WebSecurityConfig {

    @Bean
    SecurityWebFilterChain springSecurityFilterChain(
            ServerHttpSecurity http,
            ReactiveAuthenticationManager reactiveAuthenticationManager,
            @Qualifier("yaAuthenticationConverter") ServerAuthenticationConverter serverAuthenticationConverter,
            YaServerAuthenticationEntryPoint yaServerAuthenticationEntryPoint,
            YaServerAccessDeniedHandler yaServerAccessDeniedHandler) {
        // TODO Check if all settings are necessary and sufficient
        // TODO Setup per endpoint authentication
        // TODO Allow anonymous for some endpoints
        http.csrf().disable();
        http.httpBasic().disable();
        http.formLogin().disable();
        http.logout().disable();
        http.requestCache().disable();
        http.securityContextRepository(NoOpServerSecurityContextRepository.getInstance());
        AuthenticationWebFilter authenticationWebFilter = new AuthenticationWebFilter(reactiveAuthenticationManager);
        authenticationWebFilter.setServerAuthenticationConverter(serverAuthenticationConverter);
        final ServerAuthenticationEntryPointFailureHandler authenticationFailureHandler =
                new ServerAuthenticationEntryPointFailureHandler(yaServerAuthenticationEntryPoint);
        authenticationWebFilter.setAuthenticationFailureHandler(authenticationFailureHandler);
        http.addFilterAt(authenticationWebFilter, SecurityWebFiltersOrder.AUTHENTICATION);
        http.exceptionHandling().accessDeniedHandler(yaServerAccessDeniedHandler);
        http.exceptionHandling().authenticationEntryPoint(yaServerAuthenticationEntryPoint);
        http.authorizeExchange().pathMatchers("/local/*").permitAll();
        http.authorizeExchange().pathMatchers("/ping").permitAll();
        http.authorizeExchange().anyExchange().authenticated();
        return http.build();
    }

    @Bean
    WebSessionManager webSessionManager() {
        return NoOpWebSessionManager.getInstance();
    }

}
