package ru.yandex.intranet.d.web.security.blackbox.model;

/**
 * Blackbox exception.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class BlackboxException extends RuntimeException {

    public static final long OK = 0L;
    public static final long INVALID_PARAMS = 2L;
    public static final long DB_EXCEPTION = 10L;
    public static final long ACCESS_DENIED = 21L;
    public static final long UNKNOWN = 1L;

    private final long id;
    private final String value;
    private final String error;

    public BlackboxException(long id, String value, String error) {
        super("Blackbox returned an exception, id=" + id + ", value=" + value + ", error=" + error + ".");
        this.id = id;
        this.value = value;
        this.error = error;
    }

    public long getId() {
        return id;
    }

    public String getValue() {
        return value;
    }

    public String getError() {
        return error;
    }

}
