package ru.yandex.intranet.d.web.security.blackbox.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Blackbox OAuth response.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class BlackboxOAuthResponse {

    private final String error;
    private final BlackboxException exception;
    private final Status status;
    private final Uid uid;
    private final OAuth oauth;

    @JsonCreator
    public BlackboxOAuthResponse(
            @JsonProperty("error") String error,
            @JsonProperty("exception") BlackboxException exception,
            @JsonProperty("status") Status status,
            @JsonProperty("uid") Uid uid,
            @JsonProperty("oauth") OAuth oauth) {
        this.error = error;
        this.exception = exception;
        this.status = status;
        this.uid = uid;
        this.oauth = oauth;
    }

    public Optional<String> getError() {
        return Optional.ofNullable(error);
    }

    public Optional<BlackboxException> getException() {
        return Optional.ofNullable(exception);
    }

    public Optional<Status> getStatus() {
        return Optional.ofNullable(status);
    }

    public Optional<Uid> getUid() {
        return Optional.ofNullable(uid);
    }

    public Optional<OAuth> getOauth() {
        return Optional.ofNullable(oauth);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BlackboxOAuthResponse that = (BlackboxOAuthResponse) o;
        return Objects.equals(error, that.error) &&
                Objects.equals(exception, that.exception) &&
                Objects.equals(status, that.status) &&
                Objects.equals(uid, that.uid) &&
                Objects.equals(oauth, that.oauth);
    }

    @Override
    public int hashCode() {
        return Objects.hash(error, exception, status, uid, oauth);
    }

    @Override
    public String toString() {
        return "BlackboxOAuthResponse{" +
                "error='" + error + '\'' +
                ", exception=" + exception +
                ", status=" + status +
                ", uid=" + uid +
                ", oauth=" + oauth +
                '}';
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public static final class BlackboxException {

        public static final long OK = 0L;
        public static final long INVALID_PARAMS = 2L;
        public static final long DB_EXCEPTION = 10L;
        public static final long ACCESS_DENIED = 21L;
        public static final long UNKNOWN = 1L;

        private final long id;
        private final String value;

        @JsonCreator
        public BlackboxException(
                @JsonProperty("id") long id,
                @JsonProperty("value") String value) {
            this.id = id;
            this.value = value;
        }

        public long getId() {
            return id;
        }

        public String getValue() {
            return value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            BlackboxException exception = (BlackboxException) o;
            return id == exception.id &&
                    Objects.equals(value, exception.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(id, value);
        }

        @Override
        public String toString() {
            return "BlackboxException{" +
                    "id=" + id +
                    ", value='" + value + '\'' +
                    '}';
        }

    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public static final class Status {

        public static final long VALID = 0L;
        public static final long DISABLED = 4L;
        public static final long INVALID = 5L;

        private final long id;
        private final String value;

        @JsonCreator
        public Status(
                @JsonProperty("id") long id,
                @JsonProperty("value") String value) {
            this.id = id;
            this.value = value;
        }

        public long getId() {
            return id;
        }

        public String getValue() {
            return value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status) o;
            return id == status.id &&
                    Objects.equals(value, status.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(id, value);
        }

        @Override
        public String toString() {
            return "Status{" +
                    "id=" + id +
                    ", value='" + value + '\'' +
                    '}';
        }

    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public static final class Uid {

        private final String value;

        @JsonCreator
        public Uid(@JsonProperty("value") String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            Uid uid = (Uid) o;
            return Objects.equals(value, uid.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(value);
        }

        @Override
        public String toString() {
            return "Uid{" +
                    "value='" + value + '\'' +
                    '}';
        }

    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public static final class OAuth {

        private final String clientId;
        private final String clientName;
        private final String scope;

        @JsonCreator
        public OAuth(
                @JsonProperty("client_id") String clientId,
                @JsonProperty("client_name") String clientName,
                @JsonProperty("scope") String scope) {
            this.clientId = clientId;
            this.clientName = clientName;
            this.scope = scope;
        }

        @JsonProperty("client_id")
        public String getClientId() {
            return clientId;
        }

        @JsonProperty("client_name")
        public String getClientName() {
            return clientName;
        }

        public String getScope() {
            return scope;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            OAuth oAuth = (OAuth) o;
            return Objects.equals(clientId, oAuth.clientId) &&
                    Objects.equals(clientName, oAuth.clientName) &&
                    Objects.equals(scope, oAuth.scope);
        }

        @Override
        public int hashCode() {
            return Objects.hash(clientId, clientName, scope);
        }

        @Override
        public String toString() {
            return "OAuth{" +
                    "clientId='" + clientId + '\'' +
                    ", clientName='" + clientName + '\'' +
                    ", scope='" + scope + '\'' +
                    '}';
        }

    }

}
