package ru.yandex.intranet.d.web.security.blackbox.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Blackbox session id response.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class BlackboxSessionIdResponse {

    private final String error;
    private final BlackboxException exception;
    private final Status status;
    private final Uid uid;
    private final Auth auth;

    @JsonCreator
    public BlackboxSessionIdResponse(
            @JsonProperty("error") String error,
            @JsonProperty("exception") BlackboxException exception,
            @JsonProperty("status") Status status,
            @JsonProperty("uid") Uid uid,
            @JsonProperty("auth") Auth auth) {
        this.error = error;
        this.exception = exception;
        this.status = status;
        this.uid = uid;
        this.auth = auth;
    }

    public Optional<String> getError() {
        return Optional.ofNullable(error);
    }

    public Optional<BlackboxException> getException() {
        return Optional.ofNullable(exception);
    }

    public Optional<Status> getStatus() {
        return Optional.ofNullable(status);
    }

    public Optional<Uid> getUid() {
        return Optional.ofNullable(uid);
    }

    public Optional<Auth> getAuth() {
        return Optional.ofNullable(auth);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BlackboxSessionIdResponse that = (BlackboxSessionIdResponse) o;
        return Objects.equals(error, that.error) &&
                Objects.equals(exception, that.exception) &&
                Objects.equals(status, that.status) &&
                Objects.equals(uid, that.uid) &&
                Objects.equals(auth, that.auth);
    }

    @Override
    public int hashCode() {
        return Objects.hash(error, exception, status, uid, auth);
    }

    @Override
    public String toString() {
        return "BlackboxSessionIdResponse{" +
                "error='" + error + '\'' +
                ", exception=" + exception +
                ", status=" + status +
                ", uid=" + uid +
                ", auth=" + auth +
                '}';
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public static final class BlackboxException {

        public static final long OK = 0L;
        public static final long INVALID_PARAMS = 2L;
        public static final long DB_EXCEPTION = 10L;
        public static final long ACCESS_DENIED = 21L;
        public static final long UNKNOWN = 1L;

        private final long id;
        private final String value;

        @JsonCreator
        public BlackboxException(
                @JsonProperty("id") long id,
                @JsonProperty("value") String value) {
            this.id = id;
            this.value = value;
        }

        public long getId() {
            return id;
        }

        public String getValue() {
            return value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            BlackboxException exception = (BlackboxException) o;
            return id == exception.id &&
                    Objects.equals(value, exception.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(id, value);
        }

        @Override
        public String toString() {
            return "BlackboxException{" +
                    "id=" + id +
                    ", value='" + value + '\'' +
                    '}';
        }

    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public static final class Status {

        public static final long VALID = 0L;
        public static final long NEED_RESET = 1L;
        public static final long EXPIRED = 2L;
        public static final long NO_AUTH = 3L;
        public static final long DISABLED = 4L;
        public static final long INVALID = 5L;

        private final long id;
        private final String value;

        @JsonCreator
        public Status(
                @JsonProperty("id") long id,
                @JsonProperty("value") String value) {
            this.id = id;
            this.value = value;
        }

        public long getId() {
            return id;
        }

        public String getValue() {
            return value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status) o;
            return id == status.id &&
                    Objects.equals(value, status.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(id, value);
        }

        @Override
        public String toString() {
            return "Status{" +
                    "id=" + id +
                    ", value='" + value + '\'' +
                    '}';
        }

    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public static final class Uid {

        private final String value;

        @JsonCreator
        public Uid(@JsonProperty("value") String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            Uid uid = (Uid) o;
            return Objects.equals(value, uid.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(value);
        }

        @Override
        public String toString() {
            return "Uid{" +
                    "value='" + value + '\'' +
                    '}';
        }

    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public static final class Auth {

        private final boolean secure;

        @JsonCreator
        public Auth(@JsonProperty("secure") boolean secure) {
            this.secure = secure;
        }

        public boolean isSecure() {
            return secure;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            Auth auth = (Auth) o;
            return secure == auth.secure;
        }

        @Override
        public int hashCode() {
            return Objects.hash(secure);
        }

        @Override
        public String toString() {
            return "Auth{" +
                    "secure=" + secure +
                    '}';
        }

    }

}
