package ru.yandex.intranet.d.web.security.blackbox.model;

import java.util.Objects;
import java.util.Optional;

/**
 * Checked OAuth token.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CheckedOAuthToken {

    private final ValidOAuthToken valid;
    private final InvalidOAuthToken invalid;

    private CheckedOAuthToken(ValidOAuthToken valid, InvalidOAuthToken invalid) {
        this.valid = valid;
        this.invalid = invalid;
    }

    public static CheckedOAuthToken valid(ValidOAuthToken valid) {
        return new CheckedOAuthToken(valid, null);
    }

    public static CheckedOAuthToken invalid(InvalidOAuthToken invalid) {
        return new CheckedOAuthToken(null, invalid);
    }

    public Optional<ValidOAuthToken> getValid() {
        return Optional.ofNullable(valid);
    }

    public Optional<InvalidOAuthToken> getInvalid() {
        return Optional.ofNullable(invalid);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CheckedOAuthToken that = (CheckedOAuthToken) o;
        return Objects.equals(valid, that.valid) &&
                Objects.equals(invalid, that.invalid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(valid, invalid);
    }

    @Override
    public String toString() {
        return "CheckedOAuthToken{" +
                "valid=" + valid +
                ", invalid=" + invalid +
                '}';
    }

}
