package ru.yandex.intranet.d.web.security.blackbox.model;

import java.util.Objects;
import java.util.Optional;

/**
 * Checked session id.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CheckedSessionId {

    private final ValidSessionId valid;
    private final InvalidSessionId invalid;

    private CheckedSessionId(ValidSessionId valid, InvalidSessionId invalid) {
        this.valid = valid;
        this.invalid = invalid;
    }

    public static CheckedSessionId valid(ValidSessionId valid) {
        return new CheckedSessionId(valid, null);
    }

    public static CheckedSessionId invalid(InvalidSessionId invalid) {
        return new CheckedSessionId(null, invalid);
    }

    public Optional<ValidSessionId> getValid() {
        return Optional.ofNullable(valid);
    }

    public Optional<InvalidSessionId> getInvalid() {
        return Optional.ofNullable(invalid);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CheckedSessionId that = (CheckedSessionId) o;
        return Objects.equals(valid, that.valid) &&
                Objects.equals(invalid, that.invalid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(valid, invalid);
    }

    @Override
    public String toString() {
        return "CheckedSessionId{" +
                "valid=" + valid +
                ", invalid=" + invalid +
                '}';
    }

}
