package ru.yandex.intranet.d.web.security.blackbox.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Invalid session id.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class InvalidSessionId {

    private final String error;
    private final Status status;

    public InvalidSessionId(String error, Status status) {
        this.error = error;
        this.status = status;
    }

    public String getError() {
        return error;
    }

    public Status getStatus() {
        return status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InvalidSessionId that = (InvalidSessionId) o;
        return Objects.equals(error, that.error) &&
                Objects.equals(status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(error, status);
    }

    @Override
    public String toString() {
        return "InvalidSessionId{" +
                "error='" + error + '\'' +
                ", status=" + status +
                '}';
    }

    public static final class Status {

        public static final long EXPIRED = 2L;
        public static final long NO_AUTH = 3L;
        public static final long DISABLED = 4L;
        public static final long INVALID = 5L;

        private final long id;
        private final String value;

        @JsonCreator
        public Status(
                @JsonProperty("id") long id,
                @JsonProperty("value") String value) {
            this.id = id;
            this.value = value;
        }

        public long getId() {
            return id;
        }

        public String getValue() {
            return value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status) o;
            return id == status.id &&
                    Objects.equals(value, status.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(id, value);
        }

        @Override
        public String toString() {
            return "Status{" +
                    "id=" + id +
                    ", value='" + value + '\'' +
                    '}';
        }

    }

}
