package ru.yandex.intranet.d.web.security.blackbox.model;

import java.util.Objects;
import java.util.Set;

/**
 * Valid session id.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ValidOAuthToken {

    private final String uid;
    private final String clientId;
    private final String clientName;
    private final Set<String> scopes;

    public ValidOAuthToken(String uid, String clientId, String clientName, Set<String> scopes) {
        this.uid = uid;
        this.clientId = clientId;
        this.clientName = clientName;
        this.scopes = scopes;
    }

    public String getUid() {
        return uid;
    }

    public String getClientId() {
        return clientId;
    }

    public String getClientName() {
        return clientName;
    }

    public Set<String> getScopes() {
        return scopes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidOAuthToken that = (ValidOAuthToken) o;
        return Objects.equals(uid, that.uid) &&
                Objects.equals(clientId, that.clientId) &&
                Objects.equals(clientName, that.clientName) &&
                Objects.equals(scopes, that.scopes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uid, clientId, clientName, scopes);
    }

    @Override
    public String toString() {
        return "ValidOAuthToken{" +
                "uid='" + uid + '\'' +
                ", clientId='" + clientId + '\'' +
                ", clientName='" + clientName + '\'' +
                ", scopes=" + scopes +
                '}';
    }

}
