package ru.yandex.intranet.d.web.security.blackbox.model;

import java.util.Objects;

/**
 * Valid session id.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class ValidSessionId {

    private final String uid;
    private final boolean needReset;
    private final boolean secure;

    public ValidSessionId(String uid, boolean needReset, boolean secure) {
        this.uid = uid;
        this.needReset = needReset;
        this.secure = secure;
    }

    public String getUid() {
        return uid;
    }

    public boolean isNeedReset() {
        return needReset;
    }

    public boolean isSecure() {
        return secure;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidSessionId that = (ValidSessionId) o;
        return needReset == that.needReset &&
                secure == that.secure &&
                Objects.equals(uid, that.uid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uid, needReset, secure);
    }

    @Override
    public String toString() {
        return "ValidSessionId{" +
                "uid='" + uid + '\'' +
                ", needReset=" + needReset +
                ", secure=" + secure +
                '}';
    }

}
