package ru.yandex.intranet.d.web.security.impl;

import java.util.Set;

import com.google.common.primitives.Longs;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

import ru.yandex.intranet.d.web.log.AccessLogAttributesProducer;
import ru.yandex.intranet.d.web.security.model.YaAuthenticationToken;
import ru.yandex.intranet.d.web.security.model.YaCredentials;
import ru.yandex.intranet.d.web.security.model.YaPrincipal;

/**
 * Extracts authentication headers, local stub implementation.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Profile({"local", "integration-tests", "load-testing", "test-recipe"})
@Component("yaAuthenticationConverter")
public class LocalYaAuthenticationConverter implements ServerAuthenticationConverter {

    private final AccessLogAttributesProducer accessLogAttributesProducer;

    public LocalYaAuthenticationConverter(AccessLogAttributesProducer accessLogAttributesProducer) {
        this.accessLogAttributesProducer = accessLogAttributesProducer;
    }

    @Override
    public Mono<Authentication> convert(ServerWebExchange exchange) {
        String uid = exchange.getRequest().getHeaders().getFirst("X-Ya-Uid");
        String tvmIdHeader = exchange.getRequest().getHeaders().getFirst("X-Ya-Service-Id");
        Long tvmId = tvmIdHeader != null ? Longs.tryParse(tvmIdHeader) : null;
        if (uid == null && tvmId == null) {
            return Mono.empty();
        }
        YaAuthenticationToken authentication = new YaAuthenticationToken(new YaPrincipal(uid, tvmId,
                "", "", Set.of()), new YaCredentials());
        accessLogAttributesProducer.onAuthenticationToken(exchange, authentication);
        return Mono.just(authentication);
    }

}
