package ru.yandex.intranet.d.web.security.impl;

import org.springframework.lang.NonNull;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.springframework.web.server.session.WebSessionManager;
import reactor.core.publisher.Mono;

/**
 * No-op web session manager.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class NoOpWebSessionManager implements WebSessionManager {

    private static final NoOpWebSessionManager INSTANCE = new NoOpWebSessionManager();

    private NoOpWebSessionManager() {
    }

    @NonNull
    @Override
    public Mono<WebSession> getSession(@NonNull ServerWebExchange exchange) {
        return Mono.empty();
    }

    public static NoOpWebSessionManager getInstance() {
        return INSTANCE;
    }

}
