package ru.yandex.intranet.d.web.security.impl;

import java.util.Set;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.LockedException;
import org.springframework.stereotype.Component;

import ru.yandex.intranet.d.model.providers.ProviderModel;
import ru.yandex.intranet.d.model.users.StaffAffiliation;
import ru.yandex.intranet.d.web.security.model.YaUserDetails;

/**
 * Yandex user details checker.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Component
public class YaUserDetailsChecker {

    private final Set<Long> frontTvmIds;

    public YaUserDetailsChecker(@Value("${tvm.frontId}") Set<Long> frontTvmIds) {
        this.frontTvmIds = frontTvmIds;
    }

    public void check(YaUserDetails toCheck) {
        if (toCheck.getUid().isPresent() && toCheck.getTvmServiceId().isPresent()) {
            if (!frontTvmIds.contains(toCheck.getTvmServiceId().get())) {
                throw new LockedException("Only frontend are allowed to use user tickets");
            }
        }
        if (toCheck.getUser().isPresent()) {
            if (toCheck.getUser().get().getStaffDismissed().orElse(false)) {
                throw new LockedException("Dismissed users access is denied");
            }
            // TODO Better permissions for external users
            if (toCheck.getUser().get().getStaffAffiliation().isPresent()) {
                StaffAffiliation affiliation = toCheck.getUser().get().getStaffAffiliation().get();
                boolean isRobot = toCheck.getUser().get().getStaffRobot().orElse(false);
                if (affiliation != StaffAffiliation.YANDEX
                        && !(affiliation == StaffAffiliation.EXTERNAL && isRobot)) {
                    throw new LockedException("External users access is denied");
                }
            }
            if (toCheck.getUser().get().isDeleted()) {
                throw new LockedException("Deleted users access is denied");
            }
        }
        if (!toCheck.getProviders().isEmpty()) {
            if (toCheck.getProviders().stream().allMatch(ProviderModel::isDeleted)) {
                throw new LockedException("Deleted providers access is denied");
            }
        }
    }

}
