package ru.yandex.intranet.d.web.security.model;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;

/**
 * Yandex authentication principal. Contains uid and TVM service id.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class YaPrincipal {

    private final String uid;
    private final Long tvmServiceId;
    private final String oauthClientId;
    private final String oauthClientName;
    private final Set<String> scopes;

    public YaPrincipal(String uid, Long tvmServiceId, String oauthClientId, String oauthClientName,
                       Set<String> scopes) {
        this.uid = uid;
        this.tvmServiceId = tvmServiceId;
        this.oauthClientId = oauthClientId;
        this.oauthClientName = oauthClientName;
        this.scopes = scopes;
    }

    public String getName() {
        return "";
    }

    public Optional<String> getUid() {
        return Optional.ofNullable(uid);
    }

    public Optional<Long> getTvmServiceId() {
        return Optional.ofNullable(tvmServiceId);
    }

    public Optional<String> getOAuthClientId() {
        return Optional.ofNullable(oauthClientId);
    }

    public Optional<String> getOAuthClientName() {
        return Optional.ofNullable(oauthClientName);
    }

    public Set<String> getScopes() {
        return scopes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        YaPrincipal principal = (YaPrincipal) o;
        return Objects.equals(uid, principal.uid) &&
                Objects.equals(tvmServiceId, principal.tvmServiceId) &&
                Objects.equals(oauthClientId, principal.oauthClientId) &&
                Objects.equals(oauthClientName, principal.oauthClientName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(uid, tvmServiceId, oauthClientId, oauthClientName);
    }

    @Override
    public String toString() {
        return "YaPrincipal{" +
                "uid='" + uid + '\'' +
                ", tvmServiceId=" + tvmServiceId +
                ", oauthClientId='" + oauthClientId + '\'' +
                ", oauthClientName='" + oauthClientName + '\'' +
                '}';
    }

}
