package ru.yandex.intranet.d.web.security.roles;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import org.springframework.security.access.prepost.PreAuthorize;

import ru.yandex.intranet.d.web.security.model.YaUserDetails;

/**
 * Allow any authenticated service (without user).
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Retention(RetentionPolicy.RUNTIME)
@PreAuthorize("hasRole('" + YaUserDetails.SERVICE_ROLE + "')")
public @interface ServiceRole {
}
