package ru.yandex.intranet.d.web.security.roles;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import org.springframework.security.access.prepost.PreAuthorize;

import ru.yandex.intranet.d.web.security.model.YaUserDetails;

/**
 * Allow any authenticated user or service.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Retention(RetentionPolicy.RUNTIME)
@PreAuthorize("hasAnyRole('" + YaUserDetails.USER_ROLE + "','" + YaUserDetails.SERVICE_ROLE + "')")
public @interface UserOrServiceRole {
}
