package ru.yandex.intranet.d.web.security.tvm;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

/**
 * TVM configuration.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@Configuration
@Profile({"dev", "testing", "production"})
public class TvmClientConfiguration {

    @Bean
    @Profile({"dev", "testing", "production"})
    public TvmClientParams tvmClientParams() {
        return new TvmClientParams(findBaseUrl(), findAuthToken());
    }

    private static String findBaseUrl() {
        String baseUrl = System.getenv("DEPLOY_TVM_TOOL_URL");
        if (baseUrl == null || baseUrl.isBlank()) {
            return null;
        }
        return baseUrl;
    }

    private static String findAuthToken() {
        String authToken = System.getenv("TVMTOOL_LOCAL_AUTHTOKEN");
        if (authToken == null || authToken.isBlank()) {
            return null;
        }
        return authToken;
    }

}
