package ru.yandex.intranet.d.web.security.tvm.model;

import java.util.Objects;
import java.util.Optional;

/**
 * Checked TVM service ticket.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CheckedServiceTicket {

    private final ValidServiceTicket valid;
    private final InvalidServiceTicket invalid;

    private CheckedServiceTicket(ValidServiceTicket valid, InvalidServiceTicket invalid) {
        this.valid = valid;
        this.invalid = invalid;
    }

    public static CheckedServiceTicket valid(ValidServiceTicket valid) {
        return new CheckedServiceTicket(valid, null);
    }

    public static CheckedServiceTicket invalid(InvalidServiceTicket invalid) {
        return new CheckedServiceTicket(null, invalid);
    }

    public Optional<ValidServiceTicket> getValid() {
        return Optional.ofNullable(valid);
    }

    public Optional<InvalidServiceTicket> getInvalid() {
        return Optional.ofNullable(invalid);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CheckedServiceTicket that = (CheckedServiceTicket) o;
        return Objects.equals(valid, that.valid) &&
                Objects.equals(invalid, that.invalid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(valid, invalid);
    }

    @Override
    public String toString() {
        return "CheckedServiceTicket{" +
                "valid=" + valid +
                ", invalid=" + invalid +
                '}';
    }

}
