package ru.yandex.intranet.d.web.security.tvm.model;

import java.util.Objects;
import java.util.Optional;

/**
 * Checked TVM user ticket.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class CheckedUserTicket {

    private final ValidUserTicket valid;
    private final InvalidUserTicket invalid;

    private CheckedUserTicket(ValidUserTicket valid, InvalidUserTicket invalid) {
        this.valid = valid;
        this.invalid = invalid;
    }

    public static CheckedUserTicket valid(ValidUserTicket valid) {
        return new CheckedUserTicket(valid, null);
    }

    public static CheckedUserTicket invalid(InvalidUserTicket invalid) {
        return new CheckedUserTicket(null, invalid);
    }

    public Optional<ValidUserTicket> getValid() {
        return Optional.ofNullable(valid);
    }

    public Optional<InvalidUserTicket> getInvalid() {
        return Optional.ofNullable(invalid);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CheckedUserTicket that = (CheckedUserTicket) o;
        return Objects.equals(valid, that.valid) &&
                Objects.equals(invalid, that.invalid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(valid, invalid);
    }

    @Override
    public String toString() {
        return "CheckedUserTicket{" +
                "valid=" + valid +
                ", invalid=" + invalid +
                '}';
    }

}
