package ru.yandex.intranet.d.web.security.tvm.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Invalid TVM service ticket.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class InvalidServiceTicket {

    private final String debugString;
    private final String loggingString;
    private final String error;

    @JsonCreator
    public InvalidServiceTicket(
            @JsonProperty("error") String error,
            @JsonProperty("debug_string") String debugString,
            @JsonProperty("logging_string") String loggingString) {
        this.error = error;
        this.debugString = debugString;
        this.loggingString = loggingString;
    }

    @JsonProperty("error")
    public String getError() {
        return error;
    }

    @JsonProperty("debug_string")
    public String getDebugString() {
        return debugString;
    }

    @JsonProperty("logging_string")
    public String getLoggingString() {
        return loggingString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InvalidServiceTicket that = (InvalidServiceTicket) o;
        return Objects.equals(debugString, that.debugString) &&
                Objects.equals(loggingString, that.loggingString) &&
                Objects.equals(error, that.error);
    }

    @Override
    public int hashCode() {
        return Objects.hash(debugString, loggingString, error);
    }

    @Override
    public String toString() {
        return "InvalidServiceTicket{" +
                "debugString='" + debugString + '\'' +
                ", loggingString='" + loggingString + '\'' +
                ", error='" + error + '\'' +
                '}';
    }

}
