package ru.yandex.intranet.d.web.security.tvm.model;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Invalid TVM user ticket.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class InvalidUserTicket {

    private final String error;
    private final String debugString;
    private final String loggingString;

    @JsonCreator
    public InvalidUserTicket(
            @JsonProperty("error") String error,
            @JsonProperty("debug_string") String debugString,
            @JsonProperty("logging_string") String loggingString) {
        this.debugString = debugString;
        this.loggingString = loggingString;
        this.error = error;
    }

    @JsonProperty("error")
    public String getError() {
        return error;
    }

    @JsonProperty("debug_string")
    public String getDebugString() {
        return debugString;
    }

    @JsonProperty("logging_string")
    public String getLoggingString() {
        return loggingString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InvalidUserTicket that = (InvalidUserTicket) o;
        return Objects.equals(error, that.error) &&
                Objects.equals(debugString, that.debugString) &&
                Objects.equals(loggingString, that.loggingString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(error, debugString, loggingString);
    }

    @Override
    public String toString() {
        return "InvalidUserTicket{" +
                "error='" + error + '\'' +
                ", debugString='" + debugString + '\'' +
                ", loggingString='" + loggingString + '\'' +
                '}';
    }

}
