package ru.yandex.intranet.d.web.security.tvm.model;

import java.util.Objects;

/**
 * TVM daemon status.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
public final class TvmStatus {

    private final Status status;
    private final String message;

    public TvmStatus(Status status, String message) {
        this.status = status;
        this.message = message;
    }

    public Status getStatus() {
        return status;
    }

    public String getMessage() {
        return message;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TvmStatus tvmStatus = (TvmStatus) o;
        return status == tvmStatus.status &&
                Objects.equals(message, tvmStatus.message);
    }

    @Override
    public int hashCode() {
        return Objects.hash(status, message);
    }

    @Override
    public String toString() {
        return "TvmStatus{" +
                "status=" + status +
                ", message='" + message + '\'' +
                '}';
    }

    public enum Status {
        OK,
        WARN,
        ERROR,
    }

}
