package ru.yandex.intranet.d.web.security.tvm.model;

import java.util.Objects;
import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Obtained TVM ticket.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public final class TvmTicket {

    private final String ticket;
    private final long tvmId;
    private final String error;

    @JsonCreator
    public TvmTicket(@JsonProperty("ticket") String ticket,
                     @JsonProperty("tvm_id") long tvmId,
                     @JsonProperty("error") String error) {
        this.ticket = ticket;
        this.tvmId = tvmId;
        this.error = error;
    }

    @JsonProperty("ticket")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<String> getTicket() {
        return Optional.ofNullable(ticket);
    }

    @JsonProperty("tvm_id")
    public long getTvmId() {
        return tvmId;
    }

    @JsonProperty("error")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public Optional<String> getError() {
        return Optional.ofNullable(error);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TvmTicket tvmTicket = (TvmTicket) o;
        return tvmId == tvmTicket.tvmId &&
                Objects.equals(ticket, tvmTicket.ticket) &&
                Objects.equals(error, tvmTicket.error);
    }

    @Override
    public int hashCode() {
        return Objects.hash(ticket, tvmId, error);
    }

    @Override
    public String toString() {
        return "TvmTicket{" +
                "ticket='" + ticket + '\'' +
                ", tvmId=" + tvmId +
                ", error='" + error + '\'' +
                '}';
    }

}
