package ru.yandex.intranet.d.web.security.tvm.model;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Valid TVM service ticket.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE,
        isGetterVisibility = JsonAutoDetect.Visibility.NONE)
public final class ValidServiceTicket {

    @JsonProperty("src")
    private final long source;
    @JsonProperty("dst")
    private final long destination;
    @JsonProperty("scopes")
    private final List<String> scopes;
    @JsonProperty("debug_string")
    private final String debugString;
    @JsonProperty("logging_string")
    private final String loggingString;

    @JsonCreator
    public ValidServiceTicket(
            @JsonProperty("src") long source,
            @JsonProperty("dst") long destination,
            @JsonProperty("scopes") List<String> scopes,
            @JsonProperty("debug_string") String debugString,
            @JsonProperty("logging_string") String loggingString) {
        this.source = source;
        this.destination = destination;
        this.scopes = scopes;
        this.debugString = debugString;
        this.loggingString = loggingString;
    }

    public long getSource() {
        return source;
    }

    public long getDestination() {
        return destination;
    }

    public List<String> getScopes() {
        return scopes != null ? scopes : Collections.emptyList();
    }

    public String getDebugString() {
        return debugString;
    }

    public String getLoggingString() {
        return loggingString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidServiceTicket that = (ValidServiceTicket) o;
        return source == that.source &&
                destination == that.destination &&
                Objects.equals(scopes, that.scopes) &&
                Objects.equals(debugString, that.debugString) &&
                Objects.equals(loggingString, that.loggingString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(source, destination, scopes, debugString, loggingString);
    }

    @Override
    public String toString() {
        return "ValidServiceTicket{" +
                "source=" + source +
                ", destination=" + destination +
                ", scopes=" + scopes +
                ", debugString='" + debugString + '\'' +
                ", loggingString='" + loggingString + '\'' +
                '}';
    }

}
