package ru.yandex.intranet.d.web.security.tvm.model;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Valid TVM user ticket.
 *
 * @author Dmitriy Timashov <dm-tim@yandex-team.ru>
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE,
        isGetterVisibility = JsonAutoDetect.Visibility.NONE)
public final class ValidUserTicket {

    @JsonProperty("default_uid")
    private final long defaultUid;
    @JsonProperty("uids")
    private final List<Long> uids;
    @JsonProperty("scopes")
    private final List<String> scopes;
    @JsonProperty("debug_string")
    private final String debugString;
    @JsonProperty("logging_string")
    private final String loggingString;

    @JsonCreator
    public ValidUserTicket(
            @JsonProperty("default_uid") long defaultUid,
            @JsonProperty("uids") List<Long> uids,
            @JsonProperty("scopes") List<String> scopes,
            @JsonProperty("debug_string") String debugString,
            @JsonProperty("logging_string") String loggingString) {
        this.defaultUid = defaultUid;
        this.uids = uids;
        this.scopes = scopes;
        this.debugString = debugString;
        this.loggingString = loggingString;
    }

    public long getDefaultUid() {
        return defaultUid;
    }

    public List<Long> getUids() {
        return uids != null ? uids : Collections.emptyList();
    }

    public List<String> getScopes() {
        return scopes != null ? scopes : Collections.emptyList();
    }

    public String getDebugString() {
        return debugString;
    }

    public String getLoggingString() {
        return loggingString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ValidUserTicket that = (ValidUserTicket) o;
        return defaultUid == that.defaultUid &&
                Objects.equals(uids, that.uids) &&
                Objects.equals(scopes, that.scopes) &&
                Objects.equals(debugString, that.debugString) &&
                Objects.equals(loggingString, that.loggingString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(defaultUid, uids, scopes, debugString, loggingString);
    }

    @Override
    public String toString() {
        return "ValidUserTicket{" +
                "defaultUid=" + defaultUid +
                ", uids=" + uids +
                ", scopes=" + scopes +
                ", debugString='" + debugString + '\'' +
                ", loggingString='" + loggingString + '\'' +
                '}';
    }

}
