#!/bin/sh -e

export JAVA_HOME=/usr/local/jdk-17
export LOG_DIR=/var/log/yandex/d
export TMP_DIR=/tmp
export CPU_COUNT=${CPU_COUNT:-1}
export PAR_GC_THREADS=${PAR_GC_THREADS:-1}
export CON_GC_THREADS=${CON_GC_THREADS:-1}
export MAX_HEAP=${MAX_HEAP:-1g}
export START_HEAP=${START_HEAP:-1g}
export STACK_SIZE=${STACK_SIZE:-1024k}
export MAX_DIRECT_MEM=${MAX_DIRECT_MEM:-128m}
export MAX_META_SPACE=${MAX_META_SPACE:-512m}
export CODE_CACHE_SIZE=${CODE_CACHE_SIZE:-256m}
export ACTIVE_PROFILES=${ACTIVE_PROFILES:-dev}
export EXTRA_JVM_OPTIONS=${EXTRA_JVM_OPTIONS:-}
export EXTRA_ARGS=${EXTRA_ARGS:-}
export MALLOC_ARENA_MAX=${MALLOC_ARENA_MAX:-8}
export NETTY_LEAK_DETECTION=${NETTY_LEAK_DETECTION:-simple}
export NETTY_LEAK_DETECTION_TARGET_RECORDS=${NETTY_LEAK_DETECTION_TARGET_RECORDS:-4}
export NETTY_ALLOCATOR_CACHE_TRIM_INTERVAL_MILLIS=${NETTY_ALLOCATOR_CACHE_TRIM_INTERVAL_MILLIS:-60000}

exec ${JAVA_HOME}/bin/java -server -showversion \
    -classpath '/usr/lib/yandex/d/lib/*' \
    -Djava.net.preferIPv6Addresses=true \
    -Dfile.encoding=UTF-8 \
    -Djava.io.tmpdir=${TMP_DIR} \
    -Djava.library.path=/usr/lib/yandex/d/lib-native \
    -DZstdNativePath=/usr/lib/yandex/d/lib-native/libzstd-jni-1.5.0-4.so \
    -XX:ActiveProcessorCount=${CPU_COUNT} \
    -XX:ParallelGCThreads=${PAR_GC_THREADS} \
    -XX:ConcGCThreads=${CON_GC_THREADS} \
    -XX:+UnlockExperimentalVMOptions \
    -XX:+UseShenandoahGC \
    -XX:+AlwaysPreTouch \
    -XX:+UseLargePages \
    -XX:+UseTransparentHugePages \
    -XX:+UseNUMA \
    -XX:+DisableExplicitGC \
    -Xlog:all=warning:file=${LOG_DIR}/jvm.log:time,level,tags:filecount=10,filesize=10m \
    -Xlog:safepoint=info,gc*=info,gc+ref*=debug,gc+ergo*=trace:file=${LOG_DIR}/gc.log:time,level,tags:filecount=10,filesize=10m \
    -XX:ErrorFile=${LOG_DIR}/hs_err_pid%p.log \
    -XX:+HeapDumpOnOutOfMemoryError \
    -XX:HeapDumpPath=${LOG_DIR} \
    -XX:+ExitOnOutOfMemoryError \
    -Xmx${MAX_HEAP} \
    -Xms${START_HEAP} \
    -Xss${STACK_SIZE} \
    -XX:MaxDirectMemorySize=${MAX_DIRECT_MEM} \
    -XX:MaxMetaspaceSize=${MAX_META_SPACE} \
    -XX:ReservedCodeCacheSize=${CODE_CACHE_SIZE} \
    -Dspring.profiles.active=${ACTIVE_PROFILES} \
    -Dlog4j.configurationFile=log4j2-d-deploy-config.xml \
    -Dio.netty.leakDetection.level=${NETTY_LEAK_DETECTION} \
    -Dio.netty.leakDetection.targetRecords=${NETTY_LEAK_DETECTION_TARGET_RECORDS} \
    -Dio.netty.allocator.cacheTrimIntervalMillis=${NETTY_ALLOCATOR_CACHE_TRIM_INTERVAL_MILLIS} \
    ${EXTRA_JVM_OPTIONS} \
    ru.yandex.intranet.d.DApplication \
    ${EXTRA_ARGS}
