# Описание нового (разностного) API провайдера (проект)

## Предыстория и мотивация
Ранее основной концепцией системы была "двойная бухгалтерия":
информация о квотах хранилась с одной стороны в сервисе D, и параллельно у провайдера.
При этом возникала задача их сопоставления, в частности, механика "баланса фолдера", операция "Спуска/подъёма".
Практика показала, что эти концепция и механики избыточны, и от них решено постепенно отказаться (https://st.yandex-team.ru/DISPENSER-4729).

Основываясь на потребностях концепции "двойной бухгалтерии" API провайдера было подчинено следующим принципам:
* передача абсолютных значений квот
* основной (обязательный) механизм защиты от гонок -- CAS (вместе с новыми значениями передаются старые)

#### Пример решаемой проблемы
>Рассмотрим конкретный пример, выдачу заказа. Сейчас она проходит в два этапа:
>
>1. Увеличиваем баланс -- это вызов ручки API сервиса D, получает дельту и обязательный ключ идемпотентности.
>2. Спуск в аккаунт. Это вызов ручки провайдера с CAS. Если получили таймаут, можем ретраить (CAS не позволит спустить дважды).
>
>А что будет в случае ошибки при вызове ручки провайдера?
>
>Пусть в аккаунте было 100 ядер. Пользователь заказывал еще 100 ядер. Мы их хотим выдать.
>Отправляем запрос было 100 ядер, хотим 200 ядер. Ответ не получаем (потому что сеть флапнула, например).
>И в это же время пользователю еще через заявку перевели 100 ядер из другого аккаунта, независимо от выдачи.
>И вот теперь мы не понимаем, а мы выдали 100 ядер из заказа или не выдали? У пользователя 200 ядер стало - это результат выдачи или нет?
>Повторять тот же запрос "было 100 стало 200" бесполезно, CAS не пропустит.
>Откуда взялось 200 - не понятно.
>
>Сейчас мы синкаем спущенные квоты (по всему провайдеру, раз в 30 минут), и перевычисляем балансы на фолдере.
>И видим, что если операция не выполнилась, на фолдере остался баланс -- тогда можем снова попробовать спустить его в аккаунт.
>
>Если мы откажемся от хранения баланса фолдера, в таком сценарии мы потерям определенность результата.

В свете новых концепций (когда провайдер -- единственный источник правды) наши мутирующие операции
сводятся к двум сценариям:
* перемещение квоты
* выдача (из заказа или из резерва)

В обоих сценариях нам не особо важны текущие значения квот, мы по смыслу имеем некоторую дельту,
которую хотим применить к аккаунту (одному или нескольким разом в транзакции).
Дельты могут быть с разными знаками конечно.

В плане защиты от гонок, если перейти на дельты, CAS и версионирование кажутся плохой идеей,
так как накладывают не нужные по смыслу ограничения:
для применения дельт вообще не особо важны старые значения, ни сами значения, ни их версия.
Наиболее удобной защитой от гонок для дельт представляется явный ключ идемпотентности запроса.
Он обеспечит применение дельт не более одного раза, а это то, что нужно.

Итого новыми принципами API будет:
* передача дельт (разницы между новым и старым значением квоты, те, что не меняются, можно вовсе не упоминать)
* обязательный (и единственный) механизм защиты от гонок -- ключ идемпотентности


## Ключ идемпотентности {idempotency_key}
Вместе с каждым запросом будет передаваться ключ идемпотентности -- уникальный для этой операции ID.
Этот ключ будет генерироваться и сохранятся в DB перед выполнением запросов в провайдера.
Благодаря предварительному сохранению (в запись операции) он будет одинаковый при каждом
повторении запроса по этой операции.

Провайдер также **обязан** хранить полученный в запросе ключ идемпотентности в своей DB.

>#### Вариант с очередями операций (делать не будем)
>Чтобы упростить реализацию на стороне провайдера, мы на стороне ресурсной модели бы (средствами DB)
>можем гарантировать последовательность выполнения операций в рамках одного аккаунта.
>То есть не начинаем новую операцию, пока на определим статус предыдущей.
>Чтобы это работало, нам необходим механизм надежного определения статуса операции в провайдере.
>
>Благодаря такому решению провайдер в своей DB может хранить только один ключ идемпотентности,
>только последней успешной операции.
>Его можно хранить буквально рядом с самими данными о квоте аккаунта.
>И конечно стоит сохранять ключ идемпотентности последней успешной операции в той же транзакции,
>что и данные, которые эта операция изменила.
>
> Делать это сложно (как один из вариантовЮ очереди задач с распределенными потребителями, в стиле Базинги)
> и пользователи заметят новые ограничения.
>
> Если этого не делать, провайдер должен будет завести отдельную таблицу и хранить все принятые
> ключи идемпотентности. Кажется, это несколько проще.

Для надежного определения статуса операции в провайдере, провайдер должен возвращать
ключ идемпотентности последней успешной операции в ответе ручки, читающей квоты аккаунта.
При этом нам нужно гарантированно последнее значение, защищенное от возможной модификации параллельными транзакциями.
Обеспечить это можно блокировкой кортежа, где хранится ключ идемпотентности, в той транзакции, в которой он читается.
Как вариант, если используется версионирование, то увеличивать версию при чтении тоже.

При изменениях квот, не связанных с запросом из ресурсной модели
(а такое, к сожалению, мы не можем полностью исключить),
Провайдер не должен менять ключ идемпотентности последней успешной операции.
Собственно, ряди такого случая всё и затевалось.

Получив запрос с ключом идемпотентности, совпадающий с ключом последней успешной операции,
провайдер не должен повторно выполнять запрос.

Ответ провайдера на повторный запрос должен быть всё так же успешным.
Но повторный успешный ответ не обязан (хотя и может, если это проще) в точности совпадать с прошлым ответом в части передаваемых данных о квотах.
Может быть удобнее, и даже лучше, если он будет содержать актуальные на данный момент значения квот.

Ситуация конфликта, когда параллельно шли как минимум два запроса с одинаковым ключом идемпотентности,
должна быть исключена на стороне ресурсной модели.

Поскольку провайдер должен хранить только последний ключ идемпотентности, считаем, что всё хранится вечно.

## Сообщения об ошибках
Сейчас наблюдается проблема с разнообразными локальными правилами работы провайдеров,
которые приводят к специфичным ошибкам операций. Ошибки от провайдера очень разнообразны,
содержат много технической информации, но не содержат внятных сообщений для пользователя.

Предлагается:
1. Все нарушения правил провайдера возвращать с кодом INVALID_ARGUMENT.
2. В расширенных данных ошибки присылать сообщение для конечного пользователя.
   Сообщения для разных локалей, как минимум русской и английской.

Ответственными за текст сообщения буде провайдер.
Добавить новое сообщение можно будет сразу на стороне провайдера.
Вероятно, одинаковые по смыслу ошибки у разных провайдеров будут выглядеть по-разному,
но что ж поделать.

## Возможность переносить объекты вместе с квотой
[DISPENSER-4701](https://st.yandex-team.ru/DISPENSER-4701)

Иногда возникает потребность передать в другой сервис собственно объект в провайдере
(pod set, базу данных и т.п.) вместе с аллоцированной в нем квотой.

Для этого нужны новые ручки и настройка в учетной записи провайдера, что он их поддерживает
1. GetEntitiesWithAllocated
2. MoveEntitiesWithAllocated

## Рефакторинг ручек
Сейчас есть CRUD самих аккаунтов, и редактирование разбито на несколько методов
(RenameAccount, MoveAccount, RevokeFreeTier). В свете смены подхода к ресурсной модели MoveAccount и RevokeFreeTier
теряют свой особый смысл (за балансом на фолдерах теперь следить не надо).
И, при условии реализации PATCH, можно без потери функциональности заменить их одним UpdateAccount.

Например, вместо MoveAccount будет вызов UpdateAccount({serviceId: "$newServiceId"}).

Кроме CreateAccount, сейчас есть ещё перекрывающий его CreateAccountAndProvide.
Предлагается оставить только CreateAccountAndProvide, и переименовать его в просто CreateAccount.

Вместо UpdateProvision и MoveProvision будет новая ручка с дельтами и идемпотентностью.
И по аналогии с CreateAccountAndProvide, её можно совместить с UpdateAccount.

Ручка ListAccountsByFolder, кажется, не пригодилась.

## Итого, API составят:
1. CreateAccount (? CreateAccountAndProvide)
2. GetAccount (? GetAccountAndProvision)
3. UpdateAccount (? UpdateAccountAndProvision)
4. DeleteAccount
5. ListAccounts
1. GetEntitiesWithAllocated
2. MoveEntitiesWithAllocated
