## Синхронизация истории и инкрементная синхронизация
### Как есть
В рамках концепции "двойной бухгалтерии" допускалось, что провайдер изменит данные о квотах на своей стороне.
Для учета этих изменений в системе был предусмотрен процесс регулярной синхронизации данных с провайдером.
Синхронизация состоит в регулярном полном вычитывании данных из провайдера о составе аккаунтов
и величине квот для каждого аккаунта, и записи этих данных в ресурсную модель.
Это в каком-то смысле отвечает принципам абсолютов и CAS.
Также API для синхронизации позволяет провайдеру указывать id последней операции
(он передается в запросе от ресурсной модели),
которая привела к такому состоянию квот. Но не требует этого делать, и ни один провайдер пока этого не делает.
Изменения в данных ресурсной модели, произведенные в результате синка,
записываются в историю на ровне с отдельными действиями пользователей.
Правда, без указания автора, поскольку никто из провайдеров его не сообщает (хотя это и допускается API)

В связи с планируемым отказом от механики баланса, регулярный полный синк несколько меняет свои цели.
Это теперь скорее обновление кеша, чем "бухгалтерская" операция.
Это подчеркивает проблемы, которые вообще-то и безотносительно смены концепции у регулярного синка есть.
1. Не эффективно используются аппаратные мощности. Полное вычитывание нагружает провайдера.
   Так же полное сравнение / частичное обновление данных модели нагружает ресурсную модель.
2. Не консистентность данных от провайдера. Поскольку данные провайдера вычитываются постранично,
   провайдер не может гарантировать консистентность набора данных в целом.
3. Не информативность истории после синка. Даже если провайдер указывал бы автора последнего изменения,
   в истории в ресурсной модели на него бы записались все изменения за период между синками,
   а там много чего могло произойти и много авторов поучаствовать.
4. Не надежность определения статуса операций. Синк сейчас может использоваться, в том числе,
   для уточнения результата (статуса) операций. Но, даже если бы провайдер передавал id последней
   операции, за период между синками на состояние квот аккаунта могла повлиять не одна операция.
   В результате мы не сможем уточнить статус операций, оказавшихся тут не последними.

### Предложения
Раз уж у нас теперь провайдер будет источником правды, логично было бы и ведение истории
изменений квот возложить на провайдера.
И тогда историю провайдера тоже надо синхронизировать с нашей базой.

Для записей истории необходимо обеспечить строгую очерёдность. Временной метки, даже миллисекундной,
для этого недостаточно. Для событий с одинаковой меткой времени должна быть указана последовательность.
В результате у истории должен быть уникальный ключ (возможно, составной),
сортировка по которому соответствует порядку применения изменений.
Назовем его "порядковый ключ".

В базе провайдера по порядковому ключу скорее всего будет индекс,
и если его сделать в порядке возрастания, можно будет эффективно получать записи после некоторой.
А у нас всегда будет последняя запись, которую мы получили (кроме старта синка, это надо учесть в протоколе).
Короче, синк истории естественно сделать инкрементным, а не перечитывать всё с начала времен каждый раз.

Если глобальная последовательность всех изменений почему-то не реализуется,
её достаточно сделать для изменений аккаунтов (создание, переименование, удаление).
А последовательность изменений квот может быть локальной для каждого аккаунта.
Это конечно создаст возможность временной не консистентности, например, при перемещении квоты.
Но со временем консистентность восстановится, и это кажется приемлемым.
Но если постоянная консистентность всё же важна,
записи истории должны быть глобально отсортированы
и содержать все данные для транзакционного применения изменений, возможно, о нескольких аккаунтах.
Но в любом случае последовательности следует разделить по провайдерам и пространствам аккаунтов.

Поскольку провайдер уже обязан хранить ключи идемпотентности запросов, наверно не сложно
будет в записи истории указать этот ключ, если изменение произошло по нашему запросу.
Так мы сможем гарантированно прояснить статус каждой операции (рано или поздно).

Получая новые записи истории, можно обновлять данные об аккаунтах и их квотах в базе модели,
и отказаться от полного синка состояния. Чтобы это было удобнее, данные о квотах в истории
лучше указывать в абсолютных значениях.
Так мы можем просто записывать себе в базу новые значения, ничего не вычисляя
(соответственно, не внося возможные ошибки вычислений).

В результате переход на синк истории позволит решить все текущие проблемы:
1. Инкрементный синк передаёт только новые данные и точечно их обновляет, эффективно используя аппаратные мощности.
   Такой синк можно проводить и чаще, или вовсе постоянно, через какой-нибудь механизм очереди.
2. Последовательное применение изменений, как у провайдера, повысит консистентность данных.
   А если сделать запись истории эквивалентной транзакции, то можно обеспечить полную консистентность.
3. История станет столь же информативной, как на стороне провайдера.
4. Статус (результат) каждой операции рано или поздно будет определен.

Отдельно стоит обсудить ответ провайдера на наш запрос об изменениях (квот или самих аккаунтов).
При выполнении запроса очевидно возникнет новая запись истории на стороне провайдера,
и естественно будет её вернут в ответе на запрос. Чтобы мы могли её сразу показать пользователю.
Но тут может возникнуть конфликт с синком истории, так как может появиться пробел в последовательности записей.
Можно договорится, что мы в запрос включаем текущий порядковый ключ истории,
а провайдер в ответ присылает нам все записи истории от указанного порядкового ключа до вновь созданной включительно
(синк при каждой операции). Но это может быть сложно реализуемо и плохо масштабируемо.

Более разумным кажется такое решение: хранить отдельно "последний полученный в процессе синка порядковый ключ истории".
И допустить присутствие в таблице истории более поздних записей, полученных в ответ на конкретные операции.
При очередном синке последовательность станет полной, а конфликтные по порядковому ключу записи можно просто пропускать
(они не должны измениться). Это может осложнить использование append-only хранилищ, но всё решаемо,
а простота реализации базового функционала - важнее.


В API вместо ListAccounts будет ListHistoryIncremental.
