# Модель данных

## Сущности ресурсной модели
В справочниках ресурсной модели присутствует ряд общих для всех сущностей полей. Это в частности глобально уникальный идентификатор представляющий собой UUID, строковый ключ, наименование на русском и английском языках, описание на русском и английском языках.

### Провайдер
Провайдер с точки зрения ресурсной модели предоставляет некоторое подмножество ресурсов (связь один ко многим). Ресурсная модель является источником информации о провайдерах.

Свойства провайдера:
- уникальный идентификатор провайдера
- уникальный ключ провайдера
- наименование на русском и английском языках
- описание на русском и английском языках
- идентификатор сервиса в ABC соответствующего провайдеру
- адрес API
- TVM source id для запросов от провайдера и TVM destination id для запросов к провайдеру.
- поддерживается ли более одного аккаунта на фолдер
- поддерживается ли перенос аккаунта вместе с квотой
- флаг read only запрещающий все операции с ресурсами провайдера
- поддерживается ли управление ресурсами провайдера через ресурсную модель
- поддерживаемые поля аккаунта (ключ, наименование)
- способ удаления аккаунта (soft delete или hard delete)
- поддерживается ли lastUpdate для спущенной квоты
- поддерживается ли переименование аккаунта
- является ли провайдер составным (разделен на несколько независимых частей, пример - кластера YT)
- поддерживается ли версионирование спущенных квот и каким именно образом (для каждой квоты по отдельности либо для аккаунта в целом)

Примеры провайдеров: `YT`, `YP`, `MDB`.\
Неактуальный более провайдер может быть отправлен в архив.\
Управлять провайдерами в ресурсной модели могут только администраторы ресурсной модели.\
Право на перевод провайдера в режим read only может быть предоставлено ответственным за провайдера.\
Для TVM source id и TVM destination id не требуется уникальность. При этом надо учитывать, что при не уникальном TVM source id обладатель прав на такой id сможет управлять сразу всеми связанными провайдерами. И аналогично при совпадающих TVM destination id на стороне провайдера могут возникать дополнительные сложности при определении того, какому же провайдеру предназначался запрос.

### Единицы измерения

Может возникнуть вопрос, зачем добавлять единицы измерения, а не обрабатывать в API все ресурсы в минимальных единицах. \
Причина в том, что провайдеры хотят позволять управлять своими ресурсами в ограниченном наборе единиц. \
Кому-то важно управлять только в гигабайтах и более крупных единицах, а кому-то наоборот, нужно управлять десятыми долями ядер, поэтому было решено, что провайдер для каждого из своих ресурсов выбирает набор единиц ресурсов, которые вместе образуют ансамбль единиц измерения и далее при работе со значениями ресурса явно указывает единицу измерения.\

Основные положения следующие:
- источником данных о единицах измерения является ресурсная модель;
- не накладывается никаких ограничений на внутреннее представление величин в системах провайдера;
- при обмене информацией между ресурсной моделью и провайдером всегда явно указываются используемые единицы измерения величин;
- при обмене информацией между ресурсной моделью и провайдером используются только целые величины;
- с каждым ресурсом провайдера зарегистрированным в ресурсной модели связан набор единиц измерения допустимых для представления количества этого ресурса;
- свободно конвертируемые друг в друга в рамках ресурсной модели единицы измерения объединяются в ансамбли единиц измерения, с каждым ресурсом связан ровно один такой ансамбль.

Свойства ансамбля единиц измерения:
- уникальный идентификатор ансамбля единиц измерения
- уникальный ключ ансамбля единиц измерения (DISPENSER-2956)
- наименование на русском и английском
- описание на русском и английском
- допускаются ли дробные значения при отображении величин для пользователя
- список единиц измерения

Свойства единицы измерения:
- уникальный идентификатор единицы измерения
- ключ единицы измерения уникальный в рамках ансамбля
- сокращенное наименование единицы измерения на русском и английском в различных грамматических формах
- полное наименование единицы измерения на русском и английском в различных грамматических формах
- множитель единицы измерения указанный в виде пары (основание, степень)

Например, в ансамбль "объем информации" могут входить единицы:
- байт с множителем 1
- килобайт с множителем 10^3
- мегабайт с множителем 10^6
- гигабайт с множителем 10^9
- терабайт с множителем 10^12

Неактуальные более единицы измерения и ансамбли единиц измерения могут быть отправлены в архив.\
Далее приведем некоторые детали реализации существенные для понимания ограничений используемого представления. Объемы ресурсов при сохранении в ресурсной модели приводятся к минимальной единице измерения соответствующего ансамбля и сохраняются в виде целого числа (64 бита со знаком). Таким образом, объемы ресурсов меньшие минимальной единицы в соответствующем ансамбле в ресурсной модели не представимы. И также не представимы объемы ресурсов, для которых не достаточно 64-битного целого со знаком. Аналогично, очевидным образом, ограничена и точность учета объема ресурса. Также из этого следует, что минимальная единица в ансамбле не может быть изменена. Кроме того, объем ресурса не может быть указан с точностью большей, чем минимальная разрешенная для этого ресурса единица измерения из соответствующего ансамбля, даже если для этого ансамбля разрешены дробные величины во взаимодействии с пользователем.\
Когда ресурсная модель выполняет запросы в API провайдера, а так же в ответах ресурсной модели провайдеру все объемы ресурсов приводятся к минимальной разрешенной для этого ресурса единице измерения из соответствующего ансамбля. Используемая единица измерения при этом также указывается, во избежание путаницы.\
Провайдер в своих запросах и ответах может использовать для объемов ресурсов любые единицы измерения из соответствующего ансамбля. При этом должны передаваться всегда только целые величины, а также всегда должна быть указана используемая единица измерения, во избежание путаницы. Указанный объем ресурса должен быть в точности приводимым к целой величине в минимальных единицах измерения из соответствующего ансамбля, и после такого приведения должен быть представим в виде 64-битного знакового целого. Результирующие объемы спущенных ресурсов должны удовлетворять тем же ограничениям, которые накладываются на пользовательский ввод для спуска этих ресурсов. Например, если пользователь может распоряжаться распределением дискового пространства с точностью до единиц гигабайт, то провайдер не должен разрешать спуск ресурса дискового пространства с большей гранулярностью. При несоблюдении этого условия может, например, возникнуть не спущенный остаток ресурса, который нельзя будет спустить штатным образом. В то же время объем аллоцированного ресурса, который в ресурсной модели присутствует исключительно в справочных целях, может быть представлен и с большей точностью, чем минимальная разрешенная для ресурса единица измерения из соответствующего ансамбля, но не с большей точностью, чем минимальная единица во всем этом ансамбле. То есть, например, аллоцированный объем дискового пространства может быть представлен с точностью до байта, несмотря на то что спускать дисковое пространство можно с точностью только до гигабайта.\


### Ресурс
С точки зрения ресурсной модели ресурс распределяется по квотам, некоторая часть этой квоты затем может быть спущена и далее аллоцирована в провайдере. Ресурсная модель является источником информации о ресурсах. Поддержание актуального каталога ресурсов для каждого из провайдеров является задачей ответственных за соответствующих провайдеров. Ресурсная модель предоставляет инструменты для управления соответствующим справочником.

Свойства ресурса:
- уникальный идентификатор ресурса
- уникальный в рамках провайдера ключ ресурса
- уникальный идентификатор провайдера
- наименование ресурса на русском и английском
- описание ресурса на русском и английском
- уникальный идентификатор ансамбля единиц измерения ресурса
- список уникальных идентификаторов единиц измерения из ансамбля разрешенных к использованию для этого ресурса при вводе значений пользователем
- уникальный идентификатор единицы измерения из ансамбля используемой по умолчанию для этого ресурса при вводе значений пользователем
- разрешено ли управление квотами для данного ресурса
- участвует ли данный ресурс в заказе оборудования
- параметры сегментирования для данного ресурса
- режим "только для чтения" для ресурса

Примеры ресурсов: CPU в кластере hahn провайдера YT, RAM в ДЦ SAS провайдера YP.\
Неактуальные более ресурсы могут быть отправлен в архив. Для этого у них не должно быть ни одной не нулевой квоты, ничего не должно быть спущено и аллоцировано.\
Управлять ресурсами в ресурсной модели могут только администраторы ресурсной модели и ответственные от соответствующего провайдера.


### Сегментирование ресурсов
Отдельные ресурсы провайдера дополнительно могут быть сгруппированы по типам и распределены по различным сегментам. Например, рассмотрим следующие ресурсы провайдера YP: "CPU в ДЦ SAS YP-сегмента dev", "CPU в ДЦ MAN YP-сегмента dev", "CPU в ДЦ VLA YP-сегмента dev", "CPU в ДЦ SAS YP-сегмента default", "CPU в ДЦ MAN YP-сегмента default", "CPU в ДЦ VLA YP-сегмента default". Все они имеют один и тот же тип CPU. При этом для них указано две сегментации - "ДЦ" и "YP-сегмент". В первой сегментации есть три сегмента: "SAS", "MAN" и "VLA". Во второй сегментации - два сегмента: "dev" и "default".

При этом для некоторых ресурсов распределение по сегментам может отсутствовать. Например, для ресурса провайдера Solomon "количество поставляемых метрик в секунду" никакое дополнительное распределение по сегментам не требуется.\
В то же время тип ресурса требуется обязательно указывать для каждого из ресурсов, с тем чтобы можно было сформировать уникальный идентификатор ресурса в API провайдера.\
Каждому ресурсу должна соответствовать уникальная совокупность из типа ресурса и множества пар из сегментации и сегмента, так как по этой совокупности формируется уникальный идентификатор ресурса в API провайдера.\
Соответственно, параметры сегментирования для каждого сегментируемого ресурса включают в себя ровно один тип ресурса и множество пар из сегментации и сегмента. При этом для каждого ресурса в каждой сегментации может быть выбрано не более одного сегмента. В то же время не требуется для каждого из ресурсов использовать все сегментации доступные в провайдере. У ресурсов одного типа должен быть один и тот же ансамбль единиц измерения. На данный момент никакой валидации сверх этого не предусмотрено. В дальнейшем могут быть рассмотрены иные дополнительные варианты валидации, например, привязка списка обязательных сегментаций к типу ресурса.\
Для не сегментируемых ресурсов указывается только тип ресурса.

Основное назначение сегментирования ресурсов - формирование идентификаторов ресурсов и пространств аккаунтов в API провайдера, разметка ресурсов для агрегированного представления квот пользователю, а так же сопоставление ресурсов с пространствами аккаунтов для составных провайдеров. В частности, в качестве идентификатора пространства аккаунтов в API провайдера используется множество пар из ключа сегментации и ключа сегмента соответствующих этому пространству аккаунтов, а в качестве идентификатора ресурса в API провайдера используется соответствующая этому ресурсу совокупность ключа типа ресурса и множества пар из ключа сегментации и ключа сегмента. Квоты в фолдере для ресурсов провайдера одного типа могут быть просуммированы при отображении их для пользователя. Или же ресурсы провайдера в фолдере могут быть представлены сгруппированными по сегментам той или иной сегментации.
Поскольку параметры сегментирования ресурса используются для его идентификации в API провайдера, то они не могут быть изменены. Исключением является только углубление сегментирования, когда у ресурсов возникает новая дополнительная сегментация.
Сегментированный ресурс составного провайдера должен относиться к одному и только к одному из пространств аккаунтов этого провайдера. То есть множество сегментов этого ресурса должно быть таким, что ровно для одного пространства аккаунтов множество сегментов этого пространства аккаунтов является подмножеством сегментов данного ресурса.


### Типы ресурсов
Для каждого провайдера имеется свой справочник типов ресурсов. Все квоты для ресурсов одного типа могут быть просуммированы между собой в процессе агрегации при отображении квот для пользователя. Ресурсная модель является источником информации о типах ресурсов.

Свойства типа ресурсов:
- уникальный идентификатор типа ресурсов
- уникальный в рамках провайдера ключ типа ресурсов
- уникальный идентификатор провайдера
- наименование на русском и английском
- описание на русском и английском

Управление справочником типов ресурсов провайдера доступно только ответственным провайдера и администраторам ресурсной модели.


### Сегментации ресурсов
Для каждого провайдера имеется свой справочник сегментаций ресурсов. Ресурсная модель является источником информации о сегментациях ресурсов.

Свойства типа ресурсов:
- уникальный идентификатор сегментации ресурсов
- уникальный в рамках провайдера ключ сегментации ресурсов
- уникальный идентификатор провайдера
- наименование на русском и английском
- описание на русском и английском

Управление справочником сегментаций ресурсов провайдера доступно только ответственным провайдера и администраторам ресурсной модели.


### Сегменты сегментаций ресурсов
Для каждого провайдера имеется свой справочник сегментов сегментаций ресурсов. Ресурсная модель является источником информации о сегментах сегментаций ресурсов.

Свойства сегмента сегментации ресурсов:
- уникальный идентификатор сегмента
- уникальный в рамках сегментации ключ сегмента ресурсов
- уникальный идентификатор сегментации ресурсов
- наименование на русском и английском
- описание на русском и английском

Управление справочником сегментов сегментаций ресурсов провайдера доступно только ответственным провайдера и администраторам ресурсной модели.


### Сервис
Под сервисом понимается сервис в системе ABC. Сервисы образуют иерархию. Права на доступ к сервисам для просмотра и редактирования определяются в ABC. Сервис не может быть закрыт/удален/отправлен в песочницу до тех пор пока у него есть хотя бы один фолдер помимо фолдера по-умолчанию, а так же до тех пор пока в фолдере по умолчанию есть хотя бы одна ненулевая квота либо есть спущенные или аллоцированные ресурсы.

### Фолдер
С точки зрения ресурсной модели к каждому сервису может быть привязано некоторое количество фолдеров, а к каждому фолдеру может быть привязано некоторое количество квот на ресурс. Каждый фолдер привязан ровно к одному сервису и каждая квота - ровно к одному фолдеру. Свойства фолдера:
- уникальный идентификатор фолдера
- уникальный идентификатор сервиса в ABC
- наименование фолдера
- описание фолдера
- тип фолдера - обычный фолдер либо фолдер по-умолчанию, в дальнейшем могут добавляться новые типы

В рамках одного сервиса наименование уникально идентифицирует фолдер.\
Неактуальный более фолдер может быть отправлен в архив. Для этого у него не должно быть ни одной не нулевой квоты и к нему не должно быть привязано ни одного аккаунта. С фолдерами отправленными в архив никаких операций совершать больше нельзя и в провайдерах они также не могут быть использованы для привязки аккаунтов. Наименование архивированного фолдера можно переиспользовать.\
Права на доступ к фолдеру определяются исходя из прав на доступ к сервису содержащему фолдер.\
Фолдер может быть передан из одного сервиса в другой. Эту операцию может инициировать только пользователь обладающий достаточными правами на фолдер. Также эту операцию должен подтвердить пользователь обладающий достаточными правами в сервисе-приемнике.\
У каждого сервиса есть ровно один фолдер по-умолчанию возникающий при создании сервиса, он не может быть отправлен в архив или передан в другой сервис.\

### Квота на ресурс
Пусть r - ресурс из множества ресурсов R и f - фолдер из общего множества фолдеров F.
Тогда quota(r, f) - квота на ресурс r в фолдере f. Квота quota(r, f) является неотрицательным числом.

Значение квоты может быть изменено:
- за счет процессов выдачи и возврата авансов и займов
- за счет ввода в эксплуатацию заказанного оборудования
- за счет передачи количества квоты на этот же ресурс из другого фолдера
- а счет вывода оборудования из эксплуатации

Передача количества квоты на ресурс между фолдерами возможна только после подтверждения пользователем имеющим требуемые права в фолдере-приемнике. Инициировать передачу могут только пользователи имеющие требуемые права в фолдере-источнике. Пользователи имеющие требуемые права определяются исходя из прав на доступ к сервису содержащему фолдер.
Для того чтобы воспользоваться квотой на ресурс, пользователь должен инициировать спуск в аккаунт провайдера некоторого количества ресурса из своей квоты.


### Баланс ресурса
Пусть r - ресурс из множества ресурсов R и f - фолдер из общего множества фолдеров F. Тогда balance(r, f) - баланс ресурса r в фолдере f. Баланс balance(r, f) является числом. Баланс представляет собой разность между quota(r, f) и суммой закэшированных в ресурсной модели значений спущенных в провайдера объемов этого ресурса в этом фолдере provided(r, a) (где суммирование выполняется по всем аккаунтам a, которые входят в фолдер f). Поскольку для вычисления баланса используются закэшированные в ресурсной модели значения спущенных в провайдера объемов ресурса, то вычисленный в ресурсной модели баланс является eventually consistent величиной.

Баланс ресурса изменяется при:
- успешно выполненном провайдером запросе от ресурсной модели на спуск или подъем ресурса;
- при самостоятельном изменении значения объема спущенного ресурса провайдером;
- при перемещении аккаунта содержащего ресурс между фолдерами;
- успешно выполненном провайдером запросе от ресурсной модели на одновременное изменение значений двух объемов спущенных ресурсов в разных аккаунтах при передаче спущенных ресурсов между аккаунтами разных фолдеров без передачи квоты между фолдерами;

Баланс может стать отрицательным за счет изменения значения объема спущенного ресурса провайдером так, что сумма значений объемов спущенного ресурса в фолдере становится больше квоты в фолдере. При возникновении отрицательного баланса по ресурсу в ресурсной модели блокируется спуск этого ресурса в соответствующем фолдере. Допущение либо недопущение таких изменений объема спущенного ресурса остается полностью на усмотрение провайдера. Во всяком случае ожидается, что провайдер штатно не будет предпринимать действий приводящих к невозможности выполнять его обязательства перед потребителями. Помимо этого ресурсной моделью не допускается поднятие ресурса в объеме большем, чем квота на этот ресурс в фолдере.
Еще один потенциальная причина возникновения отрицательного баланса - это операции одновременно изменяющие квоту фолдера и объем ресурса спущенный в фолдере. Квотой владеет ресурсная модель, а объемом спущенного ресурса владеет провайдер, соответственно возможны расхождения, когда квота в ресурсной модели уже передана, а объем спущенного ресурса в провайдере еще не изменился. Например, при попытке переместить аккаунт в другой фолдер вместе с спущенным в него объемами ресурсов, перемещение квоты может уже произойти, а перемещение аккаунта может еще не произойти, в этот момент в фолдере-источнике возникнет отрицательный баланс. Аналогичная ситуация возможна и при попытке переместить спущенные объемы ресурсов из аккаунта в одном фолдере в аккаунт в другом фолдере вместе с квотами в фолдере. Поддержка такого рода операций не является абсолютно обязательной, она делает некоторые пользовательские сценарии существенно удобнее, хотя и ценой снижения гарантий консистентности.
Иные варианты возникновения отрицательного баланса предотвращаются за счет того, каким образом организуется взаимодействие с провайдером. А именно, при запросе на изменение значения объема спущенного ресурса провайдеру передается известное ресурсной модели на момент запроса количество этого ресурса спущенное в каждый из аккаунтов фолдера. Ресурсная модель проверяет запрос так, чтобы по имеющейся в модели информации о балансе этот запрос не приводил к возникновению отрицательного баланса по ресурсу. Провайдер в свою очередь проверяет, что полученное им значение текущего объема спущенного ресурса по каждому из аккаунтов фолдера не отличается от фактического, и выполняет запрос на спуск либо подъем только если отличия отсутствуют. Измененные значения объемов спущенных ресурсов по аккаунту передаются в запросе как новые абсолютные значения. При этом новые значения передаются только для изменяемых объемов спущенных ресурсов, а не для всех вообще ресурсов в фолдере. От провайдера также требуется обеспечить достаточную степень изоляции для конкурентных запросов на спуск и подъем квоты. Как указано в базовых ожиданиях, результат конкурентного выполнения операций должен быть эквивалентен результату некоторого последовательного выполнения операций. Например, если две конкурирующих операции изменения спущенного объема ресурса параллельно прошли проверку, успешно выполниться должна только одна из них, вторая должна завершиться с ошибкой как будто бы она была выполнена после первой. Также ресурсная модель принимает меры для предотвращения передачи квоты между фолдерами, если эта квота находится в процессе спуска в провайдера, например, когда запрос в провайдера уже отправлен, но ответ еще не получен. Перечисленные меры гарантируют, что любой выполненный провайдером запрос от ресурсной модели на спуск или подъем ресурса прошел проверку на то, что он не приводит к отрицательному балансу и эта проверка была выполнена с использованием актуальных данных об спущенных квотах.


### Пространства аккаунтов
Провайдер может либо не иметь пространств аккаунтов вовсе, либо иметь два и более пространства аккаунтов, такой провайдер называется составным. Пространство аккаунтов - это часть составного провайдера, такая что для каждого аккаунта в этом провайдере можно указать ровно одно пространство аккаунтов, соответствующее этом аккаунту. При этом гарантируется, что в рамках пространства аккаунтов все запросы к провайдеру могут быть выполнены успешно с ACID-гарантиями. Для того чтобы сопоставить пространства аккаунтов и соответствующие им ресурсы, для каждого пространства аккаунтов перечисляется набор сегментов, так что к пространству аккаунтов относятся только те ресурсы, у которых множество сегментов пространства аккаунтов является подмножеством сегментов ресурса. В аккаунт можно спустить только соответствующие ему ресурсы. Пространство аккаунтов может быть переведено в режим "только для чтения" независимо от остальных пространств аккаунтов составного провайдера. Идентификаторы и ключи аккаунтов в провайдере уникальны только в рамках своего пространства аккаунтов. Пространства аккаунтов, во-первых, позволяют ввести типы аккаунтов, например, в простейшем случае каждый тип аккаунта может стать отдельным пространством аккаунтов в провайдере. Во-вторых, они позволят разделить все множество аккаунтов провайдера на непересекающиеся подмножества в соответствии с внутренним разделением самого провайдера на относительно независимые части, при этом операции в рамках каждого подмножества смогут быть успешно выполнены с ACID-гарантиями. Например, можно разделить провайдер YP на пространства аккаунтов "SAS", "MAN" и "VLA". А для провайдера YT можно привести примеры пространств аккаунтов вида "Динамические таблицы в кластере markov" или "Вычислительные пулы в кластере hahn, дерево пулов default".

Свойства пространства аккаунтов:
- уникальный идентификатор пространства аккаунтов
- уникальный в рамках провайдера ключ пространства аккаунтов
- уникальный идентификатор провайдера
- наименование пространства аккаунтов на русском и английском
- описание пространства аккаунтов на русском и английском
- параметры сегментирования пространства аккаунтов
- признак включения режима "только для чтения"

Параметры сегментирования пространства аккаунтов состоят из множества уникальных идентификаторов сегментов. При этом ни одна пара сегментов из этого списка не относится к одной и той же сегментации.\
Параметры сегментирования не могут быть изменены, т.к. используются в API провайдера для идентификации пространства аккаунтов. Исключением является только углубление сегментирования, когда у пространств аккаунтов возникает новая дополнительная сегментация. При таком углублении сегментирования автоматически выполняется углубление сегментирования и для ресурсов в этом пространстве аккаунтов.\
Не используемое более пространство аккаунтов может быть отправлено в архив, для этого в нем не должно быть ни одного аккаунта и к нему не должно относиться ни одного ресурса.\
Редактировать справочник пространств аккаунтов провайдера могут только администраторы ресурсной модели и ответственные за соответствующего провайдера.


## Сущности провайдера

### Аккаунт
Каждый аккаунт привязан ровно к одному фолдеру, а каждый фолдер может иметь несколько привязанных аккаунтов. В каждый аккаунт могут быть спущены квоты для несколько ресурсов, каждый спущенный объем ресурса относится ровно к одному аккаунту, в одном аккаунте не может быть несколько различных спущенных объемов одного и того же ресурса. У каждого провайдера свой собственный набор аккаунтов. У составных провайдеров имеется несколько независимых друг от друга наборов аккаунтов.
По умолчанию ожидается что у провайдера поддерживается не более одного аккаунта на фолдер. Поддержка нескольких аккаунтов на фолдер планируется, но необходимо дополнительное обсуждение требований для этого случая.

Свойства аккаунта:
- уникальный идентификатор (уникальный в рамках провайдера либо в рамках пространства аккаунтов составного провайдера), не изменяется, может не быть человекопонятным
- уникальный (в рамках провайдера либо в рамках пространства аккаунтов составного провайдера) ключ аккаунта, не изменяется, может отсутствовать, если провайдер не поддерживает ключи аккаунтов
- наименование аккаунта, может быть изменяемым, должно быть человекопонятным, может отсутствовать, если провайдер не поддерживает именование аккаунтов
- идентификатор фолдера (обязательное поле)
- идентификатор пространства аккаунтов (обязательно для составного провайдера)
- признак free-tier аккаунта (по умолчанию false)

Уникальный идентификатор аккаунта генерируется провайдером при создании аккаунта. Уникальный ключ аккаунта, если он поддерживается провайдером, задается в запросе на создание аккаунта, при этом проверку на соответствие ключа своим ограничениям осуществляет провайдер.

Уникальный идентификатор аккаунта необходим для однозначной идентификации аккаунтов в ресурсной модели. В частности, это важно в том случае, когда ключ аккаунта может быть повторно использован после удаления аккаунта. Если идентифицировать аккаунты только по такому ключу, то для ресурсной модели эта ситуация будет выглядеть так, будто аккаунт был восстановлен или вовсе перемещен в другой сервис, хотя на самом деле это новый не связанный со старым аккаунт.

Работа с ключами аккаунтов поддерживается для провайдеров, который используют человекочитаемые ключи в своих сущностях соответствующих аккаунтами. Поскольку ключи глобально уникальные в рамках провайдера (или его пространства аккаунтов), то нужно иметь ввиду, что не удастся, например, использовать одинаковые ключи аккаунтов провайдера в разных фолдерах.
В ресурсной модели для аккаунта также сохраняется уникальный идентификатор провайдера и внутренний глобально уникальный идентификатор.\
Если провайдер поддерживает не более одного аккаунта на фолдер, то именование аккаунтов не является обязательным и может быть опущено.\
В процессе внедрения ресурсной модели необходимо будет произвести миграцию, в процессе которой у каждого аккаунта необходимо будет задать его фолдер, например, дефолтный фолдер соответствующего сервиса.\
Аккаунт, в котором не спущено и не аллоцировано ни одного ресурса может быть удален. Допускается как полное удаление, так и удаление посредством выставления признака удаления. Если удаление выполняется посредством выставления признака удаления, то такие удаленные аккаунты можно получить явно запросив удаленные аккаунты, больше никаких операций с ними совершать нельзя. Способ удаления аккаунтов является атрибутом провайдера. Независимо от реализации удаления не должно допускаться повторное использование уникальных идентификаторов удаленных аккаунтов, т.к. это привело бы к путанице в ресурсной модели. Проверку, что аккаунт допустимо удалить, выполняет провайдер.\
Аккаунт может быть передан в другой фолдер, в том числе между сервисами. Передача возможна только если провайдер поддерживает более одного аккаунта на фолдер. Аккаунт может быть передан без перемещения квоты между фолдерами при условии наличия достаточного баланса в фолдере-приемнике. В этом случае у передаваемого аккаунта меняется фолдер-источник на фолдер-приемник, в фолдере-источнике баланс соответствующих ресурсов увеличивается, а в фолдере-приемнике - уменьшается. В запросе на перемещение к провайдеру при этом указываются в том числе значения объемов всех спущенных ресурсов для фолдера-источника и фолдера-приемника с тем чтобы избежать возникновения неконсистентностей. Аккаунт также может быть передан с перемещением квоты между фолдерами. В этом случае у перемещаемого аккаунта меняется фолдер-источник на фолдер-приемник, а так же из фолдера-источника в фолдер-приемник передается для каждого ресурса из передаваемого аккаунта количество квоты на этот ресурс спущенное в передаваемом аккаунте. Инициировать такой вариант передачи может только ресурсная модель. Передача возможна только после подтверждения пользователем имеющим требуемые права в фолдере-приемнике. Инициировать передачу могут только пользователи имеющие требуемые права в фолдере-источнике. Пользователи имеющие требуемые права определяются исходя из прав на доступ к сервису содержащему фолдер. Поддержка такого сценария является не обязательной, поскольку может приводить к временному возникновению отрицательного баланса на фолдере.\
Доступ к переименованию аккаунта и удалению аккаунта определяется исходя из прав на доступ к сервису содержащему фолдер. Провайдер может не поддерживать переименование или удаление аккаунта.
ACL аккаунта вычисляются провайдером в момент создания аккаунта, возможно с учетом фолдера и сервиса, а так же автора. Конкретная реализация этих ACL выбирается провайдером по своему усмотрению. Эти ACL, в частности нужны для разграничения доступа к использованию ресурсов спущенных в аккаунт и к настройкам аккаунта специфическим для провайдера.
Создание аккаунта может быть инициировано как через ресурсную модель, так и непосредственно в провайдере. При создании нового аккаунта в провайдере естественно необходимо указать фолдер, к которому будет привязан аккаунт. Иначе говоря, возможно два сценария. Во-первых, пользователь может инициировать создание аккаунта выполнив действие в ресурсной модели - явно либо неявно, например, просто первый раз спустив квоту в провайдер в фолдере. Во-вторых, пользователь может самостоятельно завести аккаунт в провайдере указав соответствующий фолдер. Предпочтительно, чтобы все провайдеры поддерживали первый сценарий, поддержка же второго сценария остается на усмотрение провайдера.
Для интеграции с провайдерами Облака необходимо рассмотреть еще следующую ситуацию.\
Создание аккаунта может быть совмещено в одну операцию со спуском ресурсов в этот аккаунт. Это может быть полезно для сценария, когда у провайдера разрешено не более одного аккаунта на фолдер. Тогда в момент первого спуска ресурсов этого провайдера в этом фолдере происходит сразу создание аккаунта и спуск ресурсов.\
У составных провайдеров и только у них с аккаунтом обязательно связано ровно одно пространство аккаунтов. Пространство аккаунтов указывается в момент создания аккаунта. Пространство аккаунтов у аккаунта не может быть изменено. В аккаунт могут быть спущены квоты только для тех ресурсов, у которых множество сегментов пространства аккаунтов является подмножеством сегментов ресурса.\


### Спущенные ресурсы
Пусть r - ресурс из множества ресурсов R и a - аккаунт из множества аккаунтов A. Тогда provided(r, a) - ресурс r спущенный в аккаунт a. Величина provided(r, a) является неотрицательным числом. Каждый объем спущенного ресурса по построению привязан к единственному фолдеру, т.к. каждый аккаунт привязан ровно к одному фолдеру. Пользователь может аллоцировать в провайдере только спущенное количество ресурса.

Объем спущенного ресурса ресурса изменяется при:
- успешно выполненном провайдером запросе от ресурсной модели на спуск либо подъем квоты
- успешно выполненном провайдером запросе от ресурсной модели на одновременное изменение двух значений объемов спущенных ресурсов в разных аккаунтах при передаче спущенных ресурсов между аккаунтами
- при самостоятельном изменении значения объема спущенного ресурса провайдером

Инициировать спуск или подъем квоты из ресурсной модели может только пользователь обладающий соответствующими правами. Пользователи имеющие требуемые права определяются исходя из прав на доступ к сервису содержащему фолдер.
Провайдер не позволяет установить значение объема спущенного ресурса в аккаунте меньшим, чем текущее значение аллоцированого объема этого ресурса, то есть объема, который выделен под объекты провайдера в аккаунте.
Предполагается, что провайдер не будет принимать спуски квоты, которые не сможет обслужить. Как именно определять возникновение такого состояния остается на усмотрение провайдера. Ресурсная модель во всяком случае ожидает получить от провайдера сообщение об ошибке с необходимыми для диагностики деталями.\
Ресурсная модель кэширует на своей стороне все спущенные квоты и периодически актуализирует кэш.
Ресурсная модель отвечает за то, чтобы не запрашивать спуски квоты превышающие квоты фолдера, а также за отслеживание баланса ресурса. Провайдер же отвечает за то, чтобы под объекты в аккаунте выделялся объем ресурсов не превышающий спущенного объема и за то, чтобы все принятые им спуски ресурсов могли быть обслужены в соответствии с его обязательствами перед потребителями.\
Провайдер может опционально поддерживать одновременное изменение двух значений объемов спущенных ресурсов в разных аккаунтах. Это может использоваться для перемещения спущенных, но еще не аллоцированных квот из одного аккаунта в другой. При этом если аккаунты находятся в разных фолдерах, то возможно два варианта - квота фолдера передается вместе с переносом между аккаунтами, либо квота фолдера не переносится и в фолдере назначения требуется наличие соответствующего объема свободной квоты.\
Необходимо принимать во внимание, что в силу технологических особенностей отдельных провайдеров спущенные в них квоты могут становиться доступным для их фактической аллокации и использования с некоторой задержкой. Например, фактическое выделение аппаратных ресурсов в провайдере может быть фоновой асинхронной операцией со временем выполнения не позволяющим дожидаться ее исполнения в интерактивном режиме.

Провайдер может поддерживать версионирование объемов спущенного ресурса. Возможно два варианта поддержки версионирования:
- версия связана с аккаунтом в провайдере и провайдер увеличивает номер версии при каждом изменении объема любого из ресурсов спущенных в этот аккаунт
- версия связана с ресурсом в аккаунте и провайдер увеличивает норме версии при каждом изменении объема этого ресурса спущенного в этот аккаунт

Номер версии должен монотонно возрастать, но при этом не обязательно каждый раз на единицу. При каждом релевантном изменении номер версии должен обязательно увеличиваться, обратное, однако, не требуется, т.е. номер версии может быть увеличен без наличия релевантного изменения.
Если провайдер поддерживает версионирование, то он отдает в своем API соответствующий номер версии вместе со значением объема спущенного ресурса. Ресурсная модель при синхронизации состояния с провайдером запоминает примененную версию данных. Это позволяет ресурсной модели определить, получены от провайдера актуальные либо устаревшие данные. Таким образом, данная возможность очень важна для синхронизации с провайдерами, API которых при чтении гарантирует только eventual consistency.
У составных провайдеров в аккаунт могут быть спущены только те ресурсы, у которых множество сегментов пространства аккаунтов этого аккаунта является подмножеством сегментов ресурса. Ресурсная модель не отправляет запросы на спуск квоты с ресурсами не удовлетворяющими этому ограничению.


### Аллокация ресурса
Под аллокацией понимается объем ресурса, который был выделен под объекты провайдера в некотором аккаунте. Пусть r - ресурс из множества ресурсов R и a - аккаунт из множества аккаунтов A. Тогда allocation(r, a) - аллокация ресурса r в аккаунте a. Аллокация allocation(r, a) является неотрицательным числом.

Провайдер не позволяет аллокации превышать спущенный объем квоты.

Разность между спущенных объемом квоты и аллокацией можно поднять из аккаунта увеличив тем самым баланс.
Как правило предполагается, что аллокация отличается от фактического использования ресурса в аккаунте. Для примера, аллокация - это количество ядер CPU выделенных в текущий момент под stage-и проекта в Deploy, а фактическое использование - это количество ядер CPU используемых stage-ами проекта в текущий момент. Возможны, однако, и иные ситуации. Например, для дисковой квоты в YT аллокация и фактическое использование - это одно и то же, т.к. поднять можно только ту часть дисковой квоты, которая не используется в текущий момент, никакого аналога stage-ей как в Deploy для дисковой квоты в YT не предусмотрено. В то же время для квот на CPU в Sandbox аллокация не определена и принимается равной нулю, в любой момент можно забрать всю спущенную квоту из аккаунта.

Ресурсная модель кэширует на своей стороне все аллокации и периодически актуализирует кэш.

Права на использование ресурсов зависят от ACL аккаунта, но конкретная реализация остается на усмотрение провайде
