# Основные понятия

В этом разделе описаны основные понятия, термины и участники процесса заказа ресурсов.

## Заказ

Под _заказом_ подразумевается весь процесс приобретения ресурсов - от планирования до выдачи ресурсов продуктовым направлениям.

Процесс заказа длится с июля по октябрь следующего года и состоит из нескольких этапов. График этапов с описанием находится на этой странице.

## Система сбора заявок

Система сбора заявок - инструмент для создания и просмотра заявок на приобретения ресурсов. Расположен на странице Заказ железа в Каталоге сервисов Яндекса по адресу <https://abc.yandex-team.ru/hardware/> и на вкладке _Заказ железа_ каждого ABC-сервиса, например <https://abc.yandex-team.ru/services/d/hardware/>.

Система также позволяет автоматически выдавать ресурсы.

## Кампания

Сущность в системе сбора заявок, используется для разделения заказов разных периодов (например, кампания _Заказ 2023_). Кампания обладает рядом характеристик:
- тип кампании;
- даты поставки;
- провайдеры, сегменты, ресурсы.

## Тип кампании

Понятие _тип кампании_ введено в систему сбора заявок при подготовке к заказу на 2023 год. Кампании могут быть двух типов: черновая и бюджетная.

Подобное разделение неявно происходило при заказе на предыдущие годы, когда инфраструктурный комитет рассматривал не конкретные заявки ABC-сервисов, а сводные данные по продуктовым направлениям и VS. Теперь сводные данные по продуктовым направлениям и VS явно фигурируют в виде отдельных заявок с большоим количеством ресурсов.

### Черновая кампания

Кампания предназаначена для заявок от ABC-сервисов. Эти заявки не рассматриваются в процессе защиты заказа, выдача ресурсов по ним производиться не будет.

Заявками в _черновой_ кампании ABC-сервисы **выражают** _Ответственному за capacity-planning_ **свою потребность** в ресурсах. Требования к обоснованию запрашиваемых ресурсов (вкладка _Защита_) - наличие и детализация расчетов, ссылок на графики и т.п., а также смена статусов заявок - на усмотрение _Ответственного за capacity-planning_ вашего VS.

Создание заявок в кампании этого типа доступно любому пользователю.

### Бюджетная кампания

_Бюджетная_ кампания предназначена для крупных заявок от продуктовых направлений и VS. Заявки в этой кампании:
- рассматриваются и корректируются в процессе защиты заказа;
- проходят через весь жизненный цикл заявок, смена статусов - обязательна и своевременна;
- учитывают естественный рост сервисов, запуск новых проектов и продуктов, резервы продуктовых направлений и VS;
- по ним провайдеры будут выдавать ресурсы. Выдача ресурсов осуществляется крупноблочно в резерв продуктового направления или VS, после получения _Ответственный за capacity-planning_ распределяет ресурсы по конечным потребителям.

Создание заявок в этой камапнии доступно только пользователям с ролями _Ответственный за заказ ресурсов_ и _Ответственный за capacity-planning_.

## Даты поставки

Каждая кампания содержит несколько дат поставки (обычно 3). Дата поставки - месяц, в течение которого провайдер выдает ресурсы заявки.

## Провайдеры, сегменты, ресурсы

Для каждой кампании настраивается список провайдеров, участвующих в заказе ресурсов. Для каждого провайдера - список ресурсов, доступных для заказа, и сегментов. Сегменты - дата-центры, кластеры, типы ресурсов и т.п.

## Заявка

Сущность, означающая потребность конкретного ABC-сервиса, продуктового направления или VS в ресурсах. Содержит в себе список ресурсов с указанием количества и обоснованием необходимости их получения. Инструкция по созданию заявки на ресурсы находится на этой странице.

У каждой заявки есть статус, означающий текущее состояние и возможные дальнейшие этапы:
- **Черновик** - статус присваивается созданной заявке;
- **Готова к защите** - заявка готова к рассмотрению Ответственным за capacity-planning;
- **Одобрена** - заявка рассмотрена Ответственным за capacity-planning и готова к обсуждению с инфраструктурным комитетом;
- **Подтверждена** - заявка подтверждена инфраструктурным комитетом. Указанное в заявке количество ресурсов будет выдано в полном объеме;
- **Квота выдана** - финальный статус, ресурсы по заявке выданы;
- **Отменена** - отмененная автором заявка;
- **Отклонена** - заявка, отклоненная Ответственным за capacity-planning или инфраструктурным комитетом. Заявку можно переоткрыть при необходимости;
- **Требуется информация** - в заявке недостаточно подробно описано (или не описано совсем) обоснование получения ресурсов или некорректно указано количество ресурсов.

## Роли и доступы

Система сбора заявок доступна всем пользователям, но выполнения некоторых действий необходимо получить соответствующую роль. Список ключевых пользователей и их возможности описаны в таблице:

Действие | Пользователь | Ответственный за Заказ ресурсов | Ответственный за capacity-planning | Ответственный за процесс
:--- | :---: | :---: | :---: | :---:
Просмотр заявок черновой кампании | да | да | да | да
Просмотр заявок бюджетной кампании | да | да | да | да
Создание заявок в черновой кампании | да | да | да | да
Создание заявок в бюджетной кампании | нет | да | да | да
Редактирование заявок в черновой кампании | нет^*^ | да | да | да
Редактирование заявок в бюджетной кампании | нет | да | да | да
Смена статуса заявок на Готова к защите в черновой кампании | нет | да | да | да
Смена статуса заявок на Готова к защите в бюджетной кампании | нет | да | да | да
Смена статуса заявок на Одобрена в черновой кампании | нет | да | да | да
Смена статуса заявок на Одобрена в бюджетной кампании | нет | нет | да | да
Смена статуса заявок на Подтверждена в черновой кампании | нет | да | да | да
Смена статуса заявок на Подтверждена в бюджетной кампании | нет | нет | нет | да

_* - если пользователь является автором заявки или является участником ABC-сервиса, к которому привязана заявка._

Создание и редактирование заявок может быть разрешено или запрещено на уровне настроек кампании.
