# Заказ серверных ресурсов

К сожалению, возможности по заказу серверных ресурсов Яндекса ограничены, а аппетиты сервисов всегда превосходят эти возможности. Поэтому каждый год мы проводим процедуру заказа серверных ресурсов, в рамках которой закупаемые серверные мощности распределяются по потребителям.

Заказ серверных ресурсов состоит из нескольких асинхронных процессов:
- заказ серверов по прогнозу роста провайдеров;
- распределение ресурсов провайдеров по подразделениям;
- распределение ресурсов подразделения по сервисам.

Типичный таймлайн подготовки заказа выглядит так:
- июль: собираются прогнозы по росту провайдеров и начинается подготовка производства серверов;
- август: подготовка заказов подразделений;
- сентябрь-октябрь: защита заказов подразделений перед инфраструктурным коммитетом.

Расписание процесса публикуется перед стартом заказа в клубе [Планирование и управление серверными ресурсами](https://clubs.at.yandex-team.ru/capacity-planning/241).

Обычно выдача ресурсов из заказа производится после поставки новых северов два раза в год - в июне и в октябре. В сезоне 2022-2023 планируется три точки выдачи ресурсов:
- декабрь 2022;
- июнь 2023;
- октябрь 2023.

Ниже можно прочитать общее описание процесса заказа.

Для более глубокого понимания рекомендуем прочитать следующие инструкции:
- [Для владельцев сервисов](/d/manuals/resource_order);
- [Для капасити-планеров](/d/responsible_for_capacity_planning/resource_order);
- [Для ответственных от провайдера](/d/provider/resource_order).

## Заказ серверов по прогнозу роста провайдеров

Главным ограничителем для закупки серверов являются бюджет и технические возможности по закупке различных компонентов. Но даже зная эти ограничения, мы не можем просто закупить сервера на все деньги и надеяться распределить их потом, потому что для разных провайдеров нужны разные конфигурации серверов и отнюдь не всегда они являются взаимозаменяемыми. Дополнительным ограничителем являются сроки поставки: даже в некризисные времена сроки начинались от 4-6 месяцев, сейчас же сроки доходят почти до года.

К счастью, большая часть серверов Яндекса потребляется стабильно растущими крупными провайдерами, что позволяет нам делать заказ на основе статистического прогноза роста провайдеров.

Чтобы учеть изменения трендов потребления ресурсов мы валидируем прогноз с крупными потребителями ресурсов и при необходимости корректируем его. На случай ошибок в распределении серверов по провайдерам мы по возможности унифицируем конфигурации серверов, закупаемых в разные провайдеры и закупаем запас компонент для доукомплектации серверов в случае необходимости их передачи между провайдерами.

## Распределение ресурсов провайдеров по подразделениям

В условиях ограниченных ресурсов мы не можем себе позволить раздавать ресурсы по потребностям в момент, когда они понадобятся, без каких-либо ограничений, потому что тогда к концу сезона мы получим дефицит ресурсов.

При этом потребляющие большую часть ресурсов провайдеров крупные проекты требуют много времени и труда для реализации и потому планируются сильно заранее - за полгода или даже за год до реальных запусков. Следовательно и серверные ресурсы под такие проекты надо закладывать заранее.

Именно такие проекты вместе с ресурсами под естественный рост составляют основу заказа сколь либо крупных подразделений.

Остаток заказа составляет заказ ресурсов под резервы подразделений, которые используются в течении года для относительно небольших спонтанных запусков и коррекции ошибок крупных прогнозов.

Решение о распределении ресурсов провайдеров по заказам подразделений принимает Инфраструктурный Комитет, собираемый из руководителей инфраструктуры и ключевых подразделений Яндекса. Чтобы это решение было осмысленным, на расмотрение коммитета выносятся уже агрегированные, крупноблочные заявки со своим продуктовым и техническим описанием, не более 5-10 штук на подразделение.

Для работы с крупноблочными заявками в ABC сделана специальная Бюджетная Кампания, заявки в которой заводят капасити-планеры и их помощники.

Чтобы помочь капасити-планерам формировать крупноблочные заявки, в ABC сделана вспомогательная Черновая Кампания, в которой представители сервисов могут заводить более гранулярные заказы.

Заявки черновой кампании не обязательны и планируются только для общения команд сервисов с их капасити-планером. Формат работы с заявками в Черновой Кампании устанавливается капасити-планером подразделения вплоть до того, что он может вообще не использовать эту кампанию, если сам знает что нужно заказывать.

Заявки черновой кампании не являются обещанием получения ресурсов со стороны инфраструктуры.

После сбора заявок Бюджетной Кампании происходит их защита перед Инфраструктурным Коммитетом и уплотнение заказов так, чтобы они укладывались в финансовые ограничения бюджета подразделений и в общее количество доступных для распределения ресурсов провайдеров. Заявки объявляются утверждёнными.

## Распределение ресурсов подразделения по сервисам

После того как заявки Бюджетной Кампании утрамбованы и утверждены, а сервера приехали и встали в строй, ресурсы заявок Бюджетной Кампании выдаются в резервы подразделений.

Обычно выдача ресурсов из заказа производится после поставки новых северов два раза в год - в июне и в октябре. В сезоне 2022-2023 планируется три точки выдачи ресурсов:
- декабрь 2022;
- июнь 2023;
- октябрь 2023.

После поступления в резерв подразделения ресурсы распределяются капасити планерами по конкретным сервисам. В качестве ориентира при этом распределении могут использоваться заявки заводимые сервисами в рамках Черновой Кампании или иные договорённости. Конкретный формат распределения ресурсов определяются капасити планером подразделения.

Кроме раздачи ресурсов по проектам в задачи капасити планера входят поддержание оперативного резерва для покрытия срочных потребностей и ошибок расчётов и перераспределение ресурсов между сервисами для их оптимального использования.

## Резервы провайдеров

Кроме резерва подразделений существует резерв провайдеров, в котором поддерживается ограниченное количество ресурсов, используемых в критических ситуациях и для спонтанных критичных для компании запусков если резервов подразделений не хватает.

Эти ресурсы выделяются только в экстренных ситуациях по запросу капасити планера и каждый раз рассматриваются в индивидуальном порядке.

## Заказ серверов вне провайдеров

Кроме провайдеров существует небольшое количество сервисов, которые по техническим причинам живут на железных серверах. Сервера для этих сервисов закупаются вместе с серверами для провайдеров и аналогично заявкам Бюджетной Кампании проходят защиту у Инфраструктурного Коммитета.
