# Управление квотами

## Как работает управление квотами
Для удобного управления количественными квотами на ресурсы (например YT или YP), в каждом сервисе ABC появилась вкладка **Квоты**. Теперь просматривать квоты сервиса, создавать запросы на изменение квот и передавать их между сервисами можно через интерфейс ABC (кроме тех провайдеров, которые проинтегрировались в режиме Read-only). Нет необходимости искать интерфейсы для просмотра квот, формы или ответственных для создания запросов на изменения для каждого провайдера ресурсов.

Информация о квотах периодически синхронизируется с провайдерами ресурсов.

Чтобы логически разделить квоты между компонентами сервиса (например, между продом и тестингом), мы ввели новую сущность — фолдер. Теперь крупным сервисам не нужно создавать для этого множество подсервисов. Вся квота сервиса находится в одном фолдере (default) либо в нескольких фолдерах. Фолдер, в отличие от сервиса — не иерархичная сущность. То есть внутри каждого сервиса может быть только плоский список фолдеров.

Информация о доступных и использованных квотах в каждом фолдере представлена следующими показателями:
- "Всего" — общий размер квоты, распределенной в фолдер. Так называемая "обещанная" квота.
- "Спущено" — квота, которая доступна для использования на стороне провайдера. Так называемая "спущенная" квота. Квоты можно спустить в существующие или новые аккаунты.
- "Баланс" — разница между общей и спущенной квотами: Всего — Cпущено = Баланс.\
Баланс показывает, сколько еще квоты можно спустить в существующие либо новые аккаунты, либо передать в другие фолдеры или сервисы.

Спущенная квота введена, чтобы уменьшить количество точек отказа. Глобальное перераспределение и просмотр квот доступны, даже если интеграция с некоторыми провайдерами не работает в данный момент. В тоже время, даже при проблемах в сервисе управления квотами, провайдер может на своей стороне аварийно увеличить размер квоты в существующем пользовательском аккаунте или создать новый. После восстановления, эта информация автоматически синхронизируется.

Отрицательный баланс говорит о том, что в аккаунты этого фолдера спущено больше квоты, чем общий размер обещанной квоты в фолдере. Чтобы это исправить, ответственный за квоты сервиса должен либо "поднять" из аккаунтов лишнюю квоту, либо сделать заявку на передачу в этот фолдер обещанной квоты из другого фолдера или сервиса, в котором на балансе есть необходимое количество квоты.

## Интерфейс управления квотами

Квоты отображаются в ABC на вкладке Квоты в виде таблицы со следующими столбцами:

![img.png](img.png)

- **Фолдер**\
    Способ разграничить квоту внутри Сервиса, например между продом и тестингом. Если такой необходимости нет, можно пользоваться дефолтным фолдером (default).
- **Провайдер**\
    Сервис-провайдер, который предоставляет квоты на ресурсы, например YT или MDS.
- **Ресурс**\
    базовая сущность для управления квотами. Ресурсы сгруппированы по типам.
- **Баланс**\
    Количество квоты, доступное либо для спуска в аккаунт, либо для передачи в другой фолдер или сервис.
    Баланс = Всего - Спущено
- **Состояние**\
    Графическое отображение баланса и аллоцированной квоты.
- **Всего**\
    Общее количество квоты ресурса в фолдере ("обещанная" квота).
- **Спущено**\
    Количество квоты, которое передано в аккаунты провайдера. Спущенными ресурсами можно распоряжаться в интерфейсе провайдера.
- **Аллоцировано**\
    Часть спущенной квоты, которую аллоцировали на стороне провайдера.


## Управлять квотами

Квотами могут управлять пользователи с ролью **Управляющий квотами**, **Руководитель сервиса** или **Управляющий сервисом**.\
Для управления квотами перейдите на страницу ABC-сервиса и выберите вкладку **Квоты**.


### Создать аккаунт

Чтобы квота стала доступной для использования, нужно "спустить" ее в аккаунт на стороне провайдера ресурсов. В каждом фолдере можно создать один или несколько аккаунтов:
- Перейдите на страницу ABC-сервиса и выберите вкладку Квоты.
- Выберите фолдер, в котром нужно создать аккаунт, и нажмите на ячейку провайдера.
![img_1.png](img_1.png)
- На панели справа нажмите Создать аккаунт.\
![img_2.png](img_2.png)
- Укажите параметры аккаунта и нажмите кнопку Создать.\
  Запрос на создание аккаунта будет отправлен в систему-провайдер ресурсов.

### Выдать (спустить) ресурсы

Чтобы выдать ресурсы из квоты, укажите аккаунт в провайдере, который будет потреблять ресурс. Для этого:
- Перейдите на страницу ABC-сервиса и выберите вкладку Квоты.
- Выберите фолдер, из которого нужно выдать ресурсы, и нажмите на ячейку провайдера.
![img_3.png](img_3.png)
- На панели справа на карточке аккаунта нажмите Изменить.
- Чтобы выдать аккаунту новый ресурс, нажмите Добавить ресурс и выберите его в списке.
- Чтобы изменить размер квоты, в поле Спущено укажите значение квоты для аккаунта. Также в поле Дельта можно указать, сколько ресурса нужно добавить или отнять у аккаунта.\
![img_4.png](img_4.png)
- Нажмите кнопку Изменить квоту.

Аккаунт получит возможность использовать выделенную квоту в интерфейсе провайдера.\
С помощью этой формы также можно "поднять" квоту -- уменьшить квоту в аккаунте (и увеличить баланс).

### Передать квоту
Квоту можно передать из одного сервиса или фолдера в другой, либо запросить квоту у другого сервиса. Для передачи квоты требуется подтверждение заявки от обоих сторон — передающей и принимающей.
Передать можно только квоту на балансе. Если квота не используется, но спущена в аккаунт, для передачи её необходимо сначала поднять на баланс.
- Перейдите на страницу ABC-сервиса и выберите вкладку Квоты.
- В правом верхнем углу страницы нажмите Передать квоту.\
  Примечание. Вы также можете выбрать фолдер и на правой панели нажать Передать квоту или Запросить квоту. В этом случае в заявку на передачу квоты будет автоматически подставлен выбранный фолдер.
- На странице Заявка на изменение квоты укажите сервис и фолдер, из которого вы хотите забрать квоту, а также сервис и фолдер, в который вы хотите передать квоту.
![img_5.png](img_5.png)
- Укажите, какие квоты нужно передать:
  - В строке Провайдер нажмите Не выбран и выберите провайдер.
  - Выберите ресурс и в поле Дельта укажите размер квоты, которую нужно передать. Можно указать как положительное, так и отрицательное значение.
  - Чтобы добавить еще один ресурс, нажмите Добавить ресурс.
  - Чтобы добавить другой провайдер, нажмите Добавить провайдер.
- Задайте название заявки и напишите комментарий.
- Нажмите кнопку Создать заявку.
- Чтобы произошла передача квоты, заявку должны подтвердить сотрудники с ролью "Управляющий квотами" от обоих сервисов — передающего и принимающего.
![img_6.png](img_6.png)\
  Все заявки на передачу квот, которые вы можете подтвердить, можно увидеть на странице https://abc.yandex-team.ru/approves/quota-transfer/
- После выполнения заявки квота появится на балансе. Для использования квоту нужно будет выдать (спустить) в аккаунт
