# Как получить ресурсы для своего ABC-сервиса

## Определения

- Направление - имеется в виду крупное подразделение в Яндексе. Это может быть Value Stream в Поисковом Портале (например, Поиск) или Business Unit (например, Такси).
- ABC-сервис - сервис в структуре <https://abc.yandex-team.ru/>
- Капасити-планнер - человек внутри каждого направления, отвечающий за управление и планирование потребления серверных ресурсов сервисами этого направления. По любым вопросам, связанным с серверными ресурсами в вашем направлении нужно обращаться к нему.

## Как получить ресурсы для своего ABC-сервиса

Есть два способа, которыми можно получить серверные ресурсы в свой ABC-сервис:

1. On-demand - быстрое получение небольшого кол-ва ресурсов от капасити-планнера для текущих нужд, для запуска или расширения небольших проектов (масштаб: единицы тысяч ядер и менее, единицы ТБ диска и менее - например, 500 ядер, 2 ТБ).
2. Предзаказ - заказ большого объёма ресурсов на год вперёд с периодическими поставками в течение года (масштаб: десятки тысяч ядер и более, единицы ПБ диска и более - например, 25000 ядер, 2 ПБ диска) для дальнейшего перераспределения этого объёма по более мелким проектам и сервисам.

## On-demand (по-умолчанию, в течение всего года)

- Чтобы получить серверные ресурсы для своего сервиса on-demand, пожалуйста, обратитесь к [ответственному за capacity-planning](https://wiki.yandex-team.ru/capacity-planning-comitee/) вашего направления.
- Для взаимодействия с капасити-планнером, мы рекомендуем сделать тикет в очередь [QUOTAREQUEST](https://st.yandex-team.ru/createTicket?queue=QUOTAREQUEST) с описанием ваших потребностей и призвать в него капасити-планнера.
- После призыва в тикет капасити-планнер рассмотрит ваш запрос, возможно, задаст уточняющие вопросы и, если будет удовлетворен обоснованием необходимости, выдаст вам необходимые ресурсы из своего резерва.

## Предзаказ (ежегодно, один раз в год)

- В случае, когда вы отвечаете за крупный проект или сервис, которому может понадобится большое количество различных ресурсов для роста и развития, схема с on-demand выдачей ресурсов не всегда будет работать.
- Мы стараемся не хранить в наших резервах большое количество ресурсов, т.к. они простаивают и не приносят компании никакой пользы. Важно соблюдать баланс между возможностью быстро получить ресурсы для запуска нового сервиса и хранением большого количества ресурсов в резервах.
- Поэтому для крупных проектов и сервисов мы, по-прежнему, просим ответственных участвовать в процессе планирования бюджета и предварительного заказа ресурсов на год вперёд и согласовывать потребности в ресурсах своих проектов с капасити-планнерами.

## Кому точно НЕ нужно участвовать в предзаказе (и использовать только on-demand способ получения ресурсов)

- Если потребность вашего сервиса в новых ресурсах очень маленькая (сотни ядер, единицы ГБ диска).
- Если капасити планнер вашего направления не хочет использовать предзаказ для сбора потребностей от сервисов направления и явно вас об этом уведомил.

### Из каких шагов состоит предзаказ, и когда он проходит

#### Обшие положения

- Любая заявка на ресурсы создаётся в рамках кампании по сбору заявок на ресурсы и привязана к ней.
- По-умолчанию, предзаказ состоит из двух кампаний:

1. Бюджетная кампания.
2. Черновая кампания.

- Бюджетная кампания является основной.
    + В этой кампании капасити-планнеры каждого направления создают крупноблочные заявки (до 10 штук на направление), объединяющие в себе все потребности сервисов и проектов, за которые они отвечают.
    + Заявки из этой кампании защищаются перед Инфра-комитетом и CFO.
    + После поставки серверов, ресурсы выдаются по заявкам из Бюджетной кампании в ABC-сервисы, к которым эти заявки привязаны.
    + Дальнейшее перераспределение между сервисами направления полученных ресурсов осуществляется капасити-планнером.
- Черновая кампания - это вспомогательная кампания, которую капасити-планеры используют для сбора и анализа потребностей владельцев сервисов ABC (вас), чтобы на их основе сделать крупноблочные заявки в Бюджетной кампании.
    + Заявки из Черновой кампании служат только для уведомления капасити-планнера о долгосрочных потребностях вашего сервиса, они не будут использоваться для дальнейших защит или для автоматической выдачи вашим сервисам заказанных ресурсов.
    + Чтобы вы смогли получить нужное вам количество ресурсов, ваш капасити-планер должен учесть ваши пожелания из заявки в Черновой кампании и заложить необходимое количество ресурсов в крупноблочной заявке в Бюджетной кампании.
    + Узнать, учёл ли капасити-планнер ваши пожелания или нет, вы можете по статусу вашей заявки в Черновой кампании ("Одобрена" или "Подтверждена") или явно спросив у капасити-планнера, призвав его в тикет заявки в Черновой кампании.

- Капасити-планнер в праве решить, будет ли он использовать Черновую кампанию для сбора потребностей от сервисов, или воспользуется своим собственным способом получения необходимой ему информации от сервисов своего направления, чтобы учесть все их потребности.
- По-умолчанию, мы считаем, что сбор потребностей от сервисов капасити-планнером происходит с помощью Черновой кампании, если капасити-планнер явно и публично не заявил обратного.
- Вся дальнейшая часть инструкции описывает формирование заявок в Черновой кампании.

#### Шаг 1. Уточнение формата взаимодействия с капасити планнером

Дедлайн: до 5 августа

- В течение первой недели заказа в клубе [Capacity planning](https://clubs.at.yandex-team.ru/capacity-planning) в этушке мы публикуем пост - объявление о старте заказа. В этом посте мы рассказываем про расписание, особенности заказа, а также явно перечисляем список направлений, в которых капасити-планнеры не будут собирать потребности своих сервисов через Черновую кампанию.
- Если ваш сервис оказался в направлении, где капасити-планнер не будет использовать Черновую кампанию, то в посте будет явно указано, что вам делать дальше.
- Во всех остальных случаях, считаем, что вам нужно завести заявку(-и) в Черновой кампании.

#### Шаг 2. Рассчитайте, сколько ресурсов вам потребуется

Дедлайн: до 21 августа

##### Общие положения

- Оцените текущее количество ресурсов у вашего(-их) сервиса(-ов) и характер их использования.
- Инструменты, которыми вы можете воспользоваться для анализа своего текущего потребления:
    + Ресурсный дашборд (сколько потребляет ваш ABC-сервис с учётом или без учёта потомков в различных провайдерах) - <https://datalens.yandex-team.ru/8qf3983emr982-billing-resursy>.
    + Страница с текущими квотами конкретного ABC-сервиса, например - <https://abc.yandex-team.ru/services/vs_search/folders/>.
    + Инструмент для поиска свободных ресурсов в ABC-сервисах - <https://abc.yandex-team.ru/free-quota/> (описание: <https://clubs.at.yandex-team.ru/capacity-planning/224>).
- Экстраполируйте потребление своего сервиса от текущего момента на 22 месяца вперёд.
    + Пример: сейчас август 2022 года. Нужен прогноз до июня 2024 года.
    + В качестве метода экстраполяции, в первом приближении, можете использовать метод линейной экстраполяции (<https://en.wikipedia.org/wiki/Extrapolation#Linear>), применив его к графикам своего сервиса на ресурсном дашборде.

##### Инструкции от провайдеров ресурсов

- YT - <https://yt.yandex-team.ru/docs/best_practices/resource_planning>

#### Шаг 3. Создайте заявку в Черновой кампании

Дедлайн: до 21 августа

- [Инструкция по созданию заявки](manuals/resource_order)
- При создании заявки укажите, сколько ресурсов требуется вашему ABC-сервису (без учета имеющихся ресурсов). При наличии, приложите графики использования имеющихся ресурсов и расчет запрашиваемого количества ресурсов к вашей заявке - эта информация поможет ответственному капасити-планнеру принять решение по вашей заявке.

#### Шаг 4. Согласуйте заявку с ответственным от вашего направления

Дедлайн: до 4 сентября

- По-умолчанию, рекомендуемым способом подтверждения заявки является перевод её капасити-планнером в статус _Одобрена_ или _Подтверждена_. Перевод в эти статусы осуществляется, если капасити-планнер учёл ваши потребности, согласен с ними и готов будет обеспечить вас ресурсами в указанный в заявке момент.
- Капасити-планнер вправе договориться с вами о своих собственных правилах согласования ваших заявок с ним. Если он решит использовать свои собственные правила согласования, то он должен явно уведомить вас об этом в посте про старт заказа в клубе [Capacity planning](https://clubs.at.yandex-team.ru/capacity-planning).

#### Шаг 5. Дождитесь подтверждения, что ваша заявка учтена в заказе подразделения, и этот заказ одобрен

Дедлайн: до 30 октября

- После согласования заявки вам нужно подождать, пока капасити планнер защитит суммарный заказ вашего подразделения.

#### Шаг 6. Обратитесь к ответственному для получения ресурсов

Когда: декабрь текущего года, июнь следующего года, октябрь следующего года

- После проведения всех защит и после первых поставок серверов провайдерам, мы начнём выдавать ресурсы капасити-планнерам по сделанным ими заявкам в Бюджетной кампаниии.
- После того, как капасити-планнеры получат ресурсы, они будут готовы перераспределять их в пользу сервисов ABC (вас).
- С этого момента вы можете обратиться к своему капасити-планнеру, призвав его в тикет своей заявки (она должна быть одобрена или подтверждена капасити-планнером), чтобы он выдал вам необходимое количество ресурсов.
