# Что нужно делать Ответственному за capacity-planning в заказе ресурсов

## Определения

- Направление - имеется в виду крупное подразделение в Яндексе. Это может быть Value Stream в Поисковом Портале (например, Поиск) или Business Unit (например, Такси).
- ABC-сервис - сервис в структуре <https://abc.yandex-team.ru/>
- Капасити-планнер - человек внутри каждого направления, отвечающий за управление и планирование потребления серверных ресурсов сервисами этого направления. По любым вопросам, связанным с серверными ресурсами в вашем направлении нужно обращаться к нему. Обязанности капасити-планнера:
	- Следить за резервами ресурсов в своём направлении.
	- Перераспределять ресурсы для удовлетворения нужд сервисов своего направления.
	- Планировать и заказывать необходимое количество ресурсов для своего направления на год вперёд.
- Резерв капасити-планнера - ABC-сервис, где капасити-планнер хранит свободные ресурсы своего направления.
- Ответственные за процесс заказа ресурсов - keyd@, sereglond@

## Процесс выдачи и заказа ресурсов с точки зрения капасити-планнера

Есть два способа, которыми ABC-сервисы могут получить ресурсы:

1. On-demand - быстрое получение небольшого количества ресурсов от капасити-планнера для текущих нужд, для запуска или расширения небольших проектов (масштаб: единицы тысяч ядер и менее, единицы ТБ диска и менее - например, 500 ядер, 2 ТБ).
1. Предзаказ - заказ большого объёма ресурсов на год вперёд с периодическими поставками в течение года (масштаб: десятки тысяч ядер и более, единицы ПБ диска и более - например, 25000 ядер, 2 ПБ диска) для дальнейшего перераспределения этого объёма по более мелким проектам и сервисам.

### On-demand (способ по-умолчанию, работает в течение всего года)

У каждого капасити-планнера есть свой собственный резерв, где он хранит свободные ресурсы своего направления. В текущей версии процесса - это обычный ABC-сервис, который нужно самостоятельно выбрать капасити-планнеру.

- Этим резервом он может распоряжаться по своему усмотрению, перераспределяя ресурсы в пользу сервисов, которым они нужны.
- Пополняется резерв через предзаказ (см. далее).

Перераспределение происходит следующим образом.

Сервис может в течение всего года обратиться к капасити-планнеру за получением дополнительных серверных ресурсов on-demand. В [инструкции](/d/quickstart/resources_order) по получению ресурсов ABC-сервисом мы рекомендуем пользователю завести тикет, описать в нём потребности своего сервиса и призвать капасити-планнера своего направления (вас).

Вам нужно рассмотреть такую заявку от сервиса и решить, готовы ли выдать по ней ресурсы или нет. При принятии решения, рекомендуем обратить внимание на следующие аспекты:
- Требуемое количество ресурсов - почему нужно именно такое количество и именно такой набор SKU?
- Для чего требуются ресурсы, какую пользу принесёт их передача в указанный сервис?
- Что произойдёт, если сервис ресурсы не получит?
- Что произойдёт, если сервис получит 50% от заказанного?

Если вы приняли решение выдать запрашиваемое количество ресурсов, то можете перенести ресурсы из своего резерва в сервис пользователя [по инструкции](/d/quickstart/resources_transfer) и сказать об этом пользователю в тикете.

### Предзаказ (происходит ежегодно, один раз в год)

В случае, когда проект или сервис являются крупными и им может понадобится большое количество разных ресурсов для роста и развития, схема с on-demand выдачей ресурсов не всегда будет работать.

Мы рекомендуем не хранить в ваших резервах большое количество свободных ресурсов, т.к. они простаивают и не приносят компании никакой пользы. Важно соблюдать баланс между возможностью быстро выдать ресурсы для запуска нового сервиса и хранением большого количества ресурсов в ваших резервах.

Чтобы соблюсти этот баланс для крупных проектов и сервисов, мы по-прежнему просим ответственных за них участвовать в процессе планирования бюджета и предварительного заказа ресурсов на год вперёд и согласовывать потребности в ресурсах своих проектов с капасити-планнерами (вами).

Серверные ресурсы для предзаказа поставляются 3 партиями, которые приходят по следующему расписанию: декабрь текущего года, июнь следующего года, октябрь следующего года.

## Из каких шагов состоит предзаказ, когда он проходит и что вам нужно делать

### Обшие положения

Любая заявка на ресурсы создаётся в рамках кампании по сбору заявок на ресурсы и привязана к ней. По-умолчанию, предзаказ состоит из двух кампаний:

1. Бюджетная кампания.
2. Черновая кампания.

- Бюджетная кампания является основной.
	- В этой кампании вам нужно создать крупноблочные заявки (до 10 штук на ваше направление), объединяющие в себе все потребности сервисов и проектов, за которые вы отвечаете.
	- Заявки из этой кампании защищаются вами и ключевыми руководителями направления перед Инфра-комитетом и CFO.
	- После поставки серверов, ресурсы выдаются по заявкам из Бюджетной кампании в ABC-сервисы, к которым вы эти заявки привязали.
	- Дальнейшее перераспределение между сервисами направления полученных ресурсов осуществляется вами.
- Черновая кампания - это вспомогательная кампания, которую вы можете использовать для сбора и анализа потребностей владельцев ABC-сервисов, и на основе заявок из Черновой кампании сделать крупноблочные заявки в Бюджетной кампании.
	- Заявки из Черновой кампании служат только для взаимодействия пользователей с вами. Они не будут использоваться для дальнейших защит или для автоматической выдачи сервисам заказанных ресурсов.
	- Вы должны решить, хотите ли вы использовать возможности Черновой кампании или нет.
	- По-умолчанию, Черновая кампания запускается для всех направлений. Если вы решаете не использовать Черновую кампанию и не хотите, чтобы пользователи присылали вам их заявки, то вам нужно явно об этом уведомить ответственных за процесс заказа (keyd@, sereglond@).

Далее будут описаны шаги, которые вам нужно пройти в рамках Предзаказа.

### Шаг 1. Решите, нужны ли вам заявки Черновой Кампании на железо от ABC-сервисов

Дедлайн: до 31 июля

- Вам, как ответственному за capacity-planning, нужно завести крупноблочные заявки в Бюджетной кампании на ресурсы для всего вашего направления (не более 10 штук).
- Чтобы понять, какое количество ресурсов вам заказать, вы можете воспользоваться информацией, предоставленной ABC-сервисами вашего направления в Черновой кампании.
- По-умолчанию, мы просим все крупные ABC-сервисы и людей, отвечающих за крупные проекты, сделать заявки в Черновой кампании, чтобы уведомить своих капасити-планнеров. В этом случае, вы должны будете дать обратную связь всем заказавшим сервисам, рассмотреть и проанализировать их заявки и, если вы считаете заявку валидной, одобрить её в системе сбора заявок ([инструкция](/d/manuals/resource_order_view)) и учесть её при создании заявки в Бюджетной кампании.
- Но, если вы уже без помощи сервисов знаете, сколько вашему направлению нужно ресурсов, вы можете отказаться от использования Черновой кампании, чтобы не делать лишнюю работу.
    + В этом случае, вам нужно написать ответственным за процесс заказа (Дмитрию Нестерову и Андрею Аброскину) письмо, что вы не будете использовать Черновую кампанию в своём направлении. В своём посте, объявляющем старт заказа, они уведомят все ABC-сервисы о направлениях, в которых сервисам не нужно создавать заявки в Черновой кампании.

### Шаг 2. Изучите заявки от ABC-сервисов в Черновой кампании (если вы не отказались от её использования)

Дедлайн: до 21 августа

Если вы отказались от использования Черновой кампании, то вы можете сразу перейти к созданию крупноблочных заявок (шаг 3). Если не отказывались, то читайте дальше.

После объявления старта заказа (в начале августа) в посте в [клубе Capacity planning](https://clubs.at.yandex-team.ru/capacity-planning), ABC-сервисы начнут создавать заявки в Черновой кампании.

Посмотреть список заявок из Черновой кампании вашего направления можно следующим образом: [Просмотр списка заявок на предзаказ](/d/manuals/resource_order_list).

Мы рекомендуем вам обрабатывать заявки в Черновой кампании следующим образом:
- Убедиться, что вы понимаете, зачем сервис просит ресурсы и какую пользу сервис принесёт, если эти ресурсы ему выдать.
- Понимаете, почему именно столько ресурсов сервису нужно.
- Понимаете, что произойдёт, если сервису не выдать нужных ресурсов или выдать только часть (например, 50%).

Если вы согласны с заявкой ABC-сервиса в Черновой кампании и готовы учесть потребности из этой заявки в своём заказе, то эту заявку нужно перевести в статус _Одобрена_. В итоге, в вашем направлении в Черновой кампании будут находиться заявки в статус _Одобрена_ и все остальные заявки в других статусах, с которыми вы не согласны и не хотите учитывать их в своём бюджете.

### Шаг 3. Создайте крупноблочные заявки от своего направления в Бюджетной кампании

Дедлайн: до 11 сентября

Теперь вам необходимо создать крупноблочные заявки в Бюджетной кампании.

Вы можете сделать это самостоятельно или делегировать создание таких заявок кому-то, кто будет вам помогать (например, это могут быть руководители крупных сервисов в вашем направлении). Если вы хотите делегировать создание заявок кому-то, то пришлите, пожалуйста, e-mail со списком таких людей ответственным за процесс заказа (keyd@, sereglond@), они выдадут соответствующие права.

Мы рекомендуем вам следующий способ создания заявок в Бюджетной кампании:
- Создать одну заявку на пополнение ваших резервов (резервов капасити-планнера), чтобы иметь возможность выдавать ресурсы on-demand пользователям в течение следующего года.
- Создать от 1 до 9 крупноблочных заявок, привязанных к крупным ABC-сервисам/проектам внутри вашего направления

	_Пример._ В VS Реклама есть 2 подразделения: Баннерная крутилка и Отдел качества рекламы. Вам нужно создать 3 заявки: в резерв, в Баннерную крутилку и в Отдел качества рекламы.
- Подробная инструкция, как создать заявку в Бюджетной кампании находится на [этой странице](/d/manuals/resource_order).
- При работе со [списком заявок](https://abc.yandex-team.ru/hardware/), чтобы посмотреть на сумму ресурсов, заказанных в Черновой кампании сервисами вашего направления, вы можете воспользоваться вкладкой "Статистика", выбрав Черновую кампанию, текущие даты поставки и ваше направление в полях фильтра.

	![Статистика по заявкам](_assets/hardware_order_stat_tab.png "Статистика по заявкам"){ width="800"}

- Также вы можете выгрузить выбранные заявки в файл Excel и продолжить работать с ними в виде эксель-таблицы.

	![Выгрузка xls-отчета](_assets/hardware_order_xls_report.png "Выгрузка xls-отчета"){ width="800"}

- Чтобы вам было проще создавать Бюджетные заявки, мы в ближайшее время реализуем автоматическое агрегирование заявок из Черновой кампании в заявку в Бюджетной кампании и обновим эту инструкцию.
- Рекомендуем ответить на все вопросы во вкладке _Защита_ ваших заявок в Бюджетной кампании, чтобы упростить их рассмотрение Инфра-комитетом и упростить согласование расходов вашего направления с руководством компании.

	![Заполнение вкладки Защита](_assets/abc_service_hardware_order_defense.png "Заполнение вкладки Защита"){ width="630"}

- Не забудьте перевести ваши крупноблочные заявки в статус _Готова к защите_.

	![Кнопки действий с заявкой](_assets/abc_service_hardware_order_card_buttons.png "Кнопки действий с заявкой"){ width="220"}

	После нажатия на кнопку _Готова к защите_, статус заявки изменится.

	![Смена статуса заявки на Готова к защите](_assets/hardware_order_ready_to_review.png "Смена статуса заявки на Готова к защите"){ width="350"}

- После дедлайна (11 сентября), все созданные заявки от направлений в Бюджетной кампании будут выгружены для подготовки к защите в Инфра-комитете и перед руководством компании.

### Шаг 4. Подготовьтесь к защите перед Инфра-комитетом

Дедлайн: до 30 сентября

После окончания сбора крупноблочных заявок в Бюджетной кампании от направлений, ответственные за процесс заказа (keyd@, sereglond@) выгрузят все полученные заявки из Бюджетной кампании и начнут подготовку к их утрамбовке в бюджет и в ограничения на количество доступных компании серверов.

В рамках этой подготовки, ответственные за процесс проверят, что из каждой заявки понятны ответы на вопросы:
- зачем нужна эта заявка?
- почему нужно именно столько ресурсов?
- что произойдёт с вашими сервисами, если вы не получите эти ресурсы?
- что будет, если вы получите неполный объем ресурсов, например 50% или 75%?
- какой процент от вашего текущего потребления составляет ваш заказ?

Если какой-то информации в заявках будет не хватит или ответы будут непонятными или неполными, ответственные за процесс придут к вам за уточнением.

После получения ответов на перечисленные выше вопросы по всем заявкам в Бюджетной кампании от направлений, ответственные за процесс заказа (keyd@, sereglond@) сформируют отчёт и отправят его всем капасити-планнерам и Инфра-комитету для дальнейшего согласования.

### Шаг 5. Уложитесь в согласованный бюджет на ваше направление

Дедлайн: до 31 октября

В течение сентября-октября для каждого направления в компании финансовым департаментом будут подготовлены бюджеты (в деньгах) на серверное оборудование на следующий год. Размеры этих бюджетов будут собраны ответственными за процесс (keyd@, sereglond@) и в качестве таргетов объявлены капасити-планнерам всех направлений.

Каждый заказываемый ресурс обладает стоимостью (в деньгах) и капасити планнеры могут видеть стоимость как для каждого заказанного ресурса в отдельности, так и для всех заявок суммарно. Карточка заявки детально описана в документе [Просмотр заявки в кампании на предзаказ](/d/manuals/resource_order_view).

![Стоимость владения ресурсами в заявке](_assets/hardware_order_cost.png "Стоимость владения ресурсами в заявке"){ width="700"}

Если суммарная стоимость заявок направления будет превышать объявленный таргет для направления, то вам будет нужно уменьшить заказываемое количество ресурсов на величину превышения.

Выдача ресурсов по крупноблочным заявкам в Бюджетной кампании такого направления будет заблокирована до тех пор, пока их суммарная стоимость не будет укладываться в бюджет направления.

После того, как стоимость всех крупноблочных заявок от направления будет укладываться в бюджет, заявки этого направления будут переведены в статус _Подтверждена_ ответственными за процесс (keyd@, sereglond@). Ресурсы будут выдаваться только по заявкам в статусе _Подтверждена_.

### Шаг 6. Получите заказанные ресурсы

Когда: декабрь текущего года, июнь следующего года, октябрь следующего года.

После подтверждения крупноблочных заявок от всех направлений вам нужно подождать, когда в провайдеры будут установлены серверы, обеспечивающие заказ серверными ресурсами.

Серверы устанавливают партиями по следующему расписанию: декабрь текущего года, июнь следующего года, октябрь следующего года.

Напомню, что все заказанные в крупноблочных заявках серверные ресурсы распределены таким же образом: декабрь текущего года, июнь следующего года, октябрь следующего года.

После того, как серверы установлены и провайдеры готовы к выдаче ресурсов, крупноблочные заявки в Бюджетной кампании перейдут в статус _Готова к выдаче_. Как только это случится, вам придёт уведомление от системы в тикет, привязанный к вашей заявке.

В части провайдеров (YP, YT, Nirvana, Sandbox, MDB, SaaS, MDS, Avatars, S3) ресурсы по крупноблочным заявкам в статусе _Готова к выдаче_ будут автоматически выданы в указанный в них ABC-сервис.

Для остальных провайдеров вам нужно будет запросить выдачу, нажав кнопку в заявке.

![Кнопка получения ресурсов по заявке](_assets/hardware_order_button.png "Кнопка получения ресурсов по заявке"){ width="550"}

### Шаг 7. Распределите ресурсы между пользователями

Когда: в течение года

После того, как вы получите ресурсы в ABC-сервисы, указанные в ваших крупноблочных заявках, вы можете начать перераспределять их между своими сервисами в on-demand режиме.

Для распределения ресурсов используйте форму передачи ресурсов ([инструкция](/d/quickstart/resources_transfer)).
