SET(spring-boot.version 2.6.6)
SET(log4j2.version 2.17.2)
SET(disruptor.version 3.4.4)
SET(xz.version 1.9)
SET(commons-compress.version 1.21)
SET(asm.version 9.2)
SET(guava.version 31.0.1-jre)
SET(grpc.version 1.45.1)
SET(error-prone-annotations.version 2.10.0)
SET(netty.version 4.1.75.Final)
SET(netty-tcnative.version 2.0.46.Final)
SET(jackson.version 2.13.2.20220328)
SET(spring-boot-grpc.version 2.13.0.RELEASE)
SET(reactor-grpc.version 1.2.3)
SET(classgraph.version 4.8.116)
SET(springdoc.version 1.5.13)
SET(commons-io.version 2.8.0)
SET(jcommander.version 1.72)
SET(proto-google-common-protos.version 2.0.1)
SET(fastutil.version 8.5.6)
SET(lz4.version 1.8.0)
SET(kotlin-logging-jvm.version 2.1.0)
SET(kotlinx-coroutines.version 1.6.0)
SET(zstd-jni.version 1.5.0-4)
SET(async-http-client.version 2.12.3)
SET(objenesis.version 3.2)
SET(resilience4j.version 1.7.1)
SET(snakeyaml.version 1.30)

INCLUDE(${ARCADIA_ROOT}/contrib/java/org/springframework/boot/spring-boot-dependencies/${spring-boot.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/org/apache/logging/log4j/log4j-bom/${log4j2.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/com/google/protobuf/protobuf-bom/${JAVA_PROTO_RUNTIME_VERSION}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/io/grpc/grpc-bom/${grpc.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/io/netty/netty-bom/${netty.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/com/fasterxml/jackson/jackson-bom/${jackson.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/org/jetbrains/kotlinx/kotlinx-coroutines-bom/${kotlinx-coroutines.version}/ya.dependency_management.inc)
INCLUDE(${ARCADIA_ROOT}/contrib/java/org/asynchttpclient/async-http-client-bom/${async-http-client.version}/ya.dependency_management.inc)
INCLUDE(${KOTLIN_BOM_FILE})

EXCLUDE(
    contrib/java/log4j/log4j
    contrib/java/org/springframework/boot/spring-boot-starter-logging
    contrib/java/org/springframework/boot/spring-boot-starter-tomcat
    contrib/java/commons-logging/commons-logging
    contrib/java/javax/activation/javax.activation-api
    contrib/java/javax/annotation/javax.annotation-api
    contrib/java/javax/websocket/javax.websocket-api
    contrib/java/javax/websocket/javax.websocket-client-api
    contrib/java/javax/xml/bind/jaxb-api
    contrib/java/javax/websocket/javax.websocket-client-api
    contrib/java/javax/websocket/javax.websocket-api
    contrib/java/javax/validation/validation-api
    contrib/java/org/apache/tomcat/embed/tomcat-embed-el
    contrib/java/io/grpc/grpc-netty-shaded
    contrib/java/com/google/protobuf/protobuf-javalite
    contrib/java/com/sun/activation/javax.activation
    contrib/java/com/sun/mail/mailapi

    library/java/tvmauth
)

DEPENDENCY_MANAGEMENT(
    contrib/java/org/ow2/asm/asm/${asm.version}
    contrib/java/org/ow2/asm/asm-commons/${asm.version}
    contrib/java/org/ow2/asm/asm-tree/${asm.version}
    contrib/java/org/ow2/asm/asm-analysis/${asm.version}
    contrib/java/com/lmax/disruptor/${disruptor.version}
    contrib/java/org/tukaani/xz/${xz.version}
    contrib/java/org/apache/commons/commons-compress/${commons-compress.version}
    contrib/java/com/google/guava/guava/${guava.version}
    contrib/java/com/google/errorprone/error_prone_annotations/${error-prone-annotations.version}
    contrib/java/io/netty/netty-transport-native-unix-common-linux-x86_64/${netty.version}
    contrib/java/io/netty/netty-tcnative-linux-x86_64/${netty-tcnative.version}
    contrib/java/io/netty/netty-tcnative-classes/${netty-tcnative.version}
    contrib/java/net/devh/grpc-spring-boot-starter/${spring-boot-grpc.version}
    contrib/java/com/salesforce/servicelibs/reactor-grpc-stub/${reactor-grpc.version}
    contrib/java/io/github/classgraph/classgraph/${classgraph.version}
    contrib/java/org/springdoc/springdoc-openapi-webflux-ui/${springdoc.version}
    contrib/java/commons-io/commons-io/${commons-io.version}
    contrib/java/com/beust/jcommander/${jcommander.version}
    contrib/java/com/google/api/grpc/proto-google-common-protos/${proto-google-common-protos.version}
    contrib/java/it/unimi/dsi/fastutil/${fastutil.version}
    contrib/java/org/lz4/lz4-java/${lz4.version}
    contrib/java/io/github/microutils/kotlin-logging-jvm/${kotlin-logging-jvm.version}
    contrib/java/com/github/luben/zstd-jni/${zstd-jni.version}
    contrib/java/org/objenesis/objenesis/${objenesis.version}
    contrib/java/io/github/resilience4j/resilience4j-kotlin/${resilience4j.version}
    contrib/java/io/github/resilience4j/resilience4j-retry/${resilience4j.version}
    contrib/java/org/yaml/snakeyaml/${snakeyaml.version}
)

