## Разработка тасклетов

У нас два тасклета: tracker и changelog. Инструкции будут на примере tracker, но для changelog все аналогично.  
Такслеты расположены в директории arc/intranet/d/tasklets.  

**Сборка бинарного файла**  
Перейти в директорию с исходниками тасклета: ```cd arc/intranet/d/tasklets/tracker```  
Запустить сборку: ```ya make```  

**Локальный запуск**  
Локальный запуск тасклета с подготовленными тестовыми данными:  
```
cd arc/intranet/d/tasklets/tracker/examples
./run_issue_create_example.sh
```
Запуск с тестовыми данными уже включает в себя билд при помощи ya make  

**Запуск тасклета в сендбоксе**  
На данном этапе можно протестировать выполнение задачи в сендбоксе, но с тестовыми входными данными.  
Чтобы загружать тасклеты в сендбокс необходимо добавить свой ssh ключ в ssh-agent:  
1) SSH Public Key должен быть указан на стаффе  
2) Запускаем ssh агент. Для этого выполняем в консоли: ```ssh-agent```  
3) Добавляем ключ в ssh-agent. Для этого выполняем в консоли: ```ssh-add```  

При этом туда передаются тестовые данные. Это способ протестировать работу таски в боевых условиях. Например, убедиться, что сендбокс имеет доступ к секретам.  
Команды для запуска в сендбокс:  
```
cd arc/intranet/d/tasklets/tracker/
./tracker run --input "`cat examples/data/issue_create.json`" --sandbox-tasklet IssueCreate
```

**Загрузка тасклета со схемой (через CI)**  
На данном этапе загружаем ресурс вместе со схемой. После этого ресурс можно использовать в a.yaml файлах.  
Делаем коммит, дожидаемся пока изменения попадут в trunk. Далее на странице релиза сервиса D запускаем flow по релизу тасклета.  
На кубике выполняющим компиляцию тасклета будет кнопка логов. В логах будет ссылка на ресурс и на MDS_UPLOAD таск.  
Номер ресурса нам пригодится на следующем шаге. Выглядит ссылка следующим образом:  
```Tasks resource has uploaded: https://sandbox.yandex-team.ru/resource/***```  
Ссылка на MDS_UPLOAD задачу выглядит так:  
```Uploading task #*** created: https://sandbox.yandex-team.ru/task/***```  
После загрузки необходимо нажать кнопку Release в созданной MDS_UPLOAD задаче (справа сверху). Это установит время жизни ресурса бесконечным, иначе ресурс будет удален через две недели.  

**Загрузка тасклета со схемой (вручную)**  
На данном этапе загружаем ресурс вместе со схемой. После этого ресурс можно использовать в a.yaml файлах.  
Вручную загружать скомпилированные тасклеты могут только пользователи Linux. Если у вас другая ОС, то используйте компиляцию через CI из предыдущего шага.  
Если ранее был произведен **Запуск тасклета в сендбоксе**, то требуется создать новый ресурс, иначе возникнет ошибка, описанная по [ссылке](https://docs.yandex-team.ru/ci/job-tasklet#cannot-find-tasklet-schema)  
```
cd arc/intranet/d/tasklets/tracker/
./tracker sb-upload --sb-schema
```
После загрузки в консоли будет ссылка на ресурс. Номер ресурса нам пригодится на следующем шаге. Выглядит ссылка следующим образом:  
```Tasks resource has uploaded: https://sandbox.yandex-team.ru/resource/***```  
И ссылка на MDS_UPLOAD задачу. Выглядит так:  
```Uploading task #*** created: https://sandbox.yandex-team.ru/task/***```  
После загрузки необходимо нажать кнопку Release в созданной MDS_UPLOAD задаче (справа сверху). Это установит время жизни ресурса бесконечным, иначе ресурс будет удален через две недели.  

**Обновление версии ресурса в CI регистре**  
В a.yaml можно указывать конкретную версию ресурса (из предыдущего шага из строки ```Tasks resource has uploaded: https://sandbox.yandex-team.ru/resource/***```), а можно указывать путь до yaml файла с описанием тасклета в CI регистре (```task: projects/d/issue_transition```).  
На данный момент мы везде используем второй вариант. Т.е. чтобы a.yaml увидел новую версию ресурса необходимо обновить ее в регистре по пути ```/trunk/arcadia/ci/registry/projects/d/```.  
При изменение тасклета changelog меняем файл:  
```
/trunk/arcadia/ci/registry/projects/d/changelog.yaml
```
При изменение тасклета tracker меняем файлы:  
```
/trunk/arcadia/ci/registry/projects/d/issue_create.yaml
/trunk/arcadia/ci/registry/projects/d/issue_coment.yaml
/trunk/arcadia/ci/registry/projects/d/issue_transition.yaml
```
После этого коммитим изменения в CI регистре и не забываем закоммитить изменения в исходном коде тасклетов. 

**Возможные ошибки**
 - При выполнении тасклета используется старая версия ресурса  
 В данном случае можно обновить файл a.yaml, чтобы CI увидела новую версию ресурса. Подробнее:  
 	* [Валидация (и обновление версий) конфигов при правках реестра](https://st.yandex-team.ru/CI-933)
 	* [Прозрачная логика обновления тасклетов в конфигах CI](https://st.yandex-team.ru/CI-1625)  

