import getpass
from typing import Optional

from ci.tasklet.common.proto import service_pb2 as ci


class ProgressModules:
    TRACKER = 'STARTREK'


class TaskletProgress:
    RUNNING = ci.TaskletProgress.Status.RUNNING
    SUCCESSFUL = ci.TaskletProgress.Status.SUCCESSFUL
    FAILED = ci.TaskletProgress.Status.FAILED


class UpdateProgressMixin:
    def update_progress(self,
                        id_: str,
                        status: ci.TaskletProgress.Status,
                        progress: float = 0,
                        text: Optional[str] = None,
                        module: Optional[str] = None,
                        url: str = ''):
        progress_ = ci.TaskletProgress()
        progress_.job_instance_id.CopyFrom(self.input.context.job_instance_id)
        progress_.id = id_
        progress_.progress = progress
        progress_.text = text
        progress_.module = module
        progress_.url = url
        progress_.status = status
        if getpass.getuser() == 'sandbox':
            self.ctx.ci.UpdateProgress(progress_)
