from .tracker import (
    format_issue_url,
    get_tracker_client,
)
from .common import (
    ProgressModules,
    TaskletProgress,
    UpdateProgressMixin,
)
from intranet.d.tasklets.tracker.proto import issue_comment_tasklet


class IssueCommentImpl(UpdateProgressMixin, issue_comment_tasklet.IssueCommentBase):
    def run(self):
        kwargs = {
            'text': self.input.config.text,
        }
        if self.input.config.summonees:
            kwargs['summonees'] = list(self.input.config.summonees)

        tracker_client = get_tracker_client(self.ctx.yav, self.input.config.tracker)
        issue = tracker_client.issues[self.input.issue.key]

        comment = issue.comments.create(**kwargs)
        issue_url = format_issue_url(issue.key, self.input.config.tracker.api_url)

        self.output.comment.issue.key = issue.key
        self.output.comment.long_id = comment.longId

        self.update_progress(
            'issue_comment',
            module=ProgressModules.TRACKER,
            status=TaskletProgress.SUCCESSFUL,
            text='Issue comment created successfully',
            url=f'{issue_url}/#{comment.longId}'
        )
