from .tracker import (
    format_issue_url,
    get_tracker_client,
)
from .common import (
    ProgressModules,
    TaskletProgress,
    UpdateProgressMixin,
)
from intranet.d.tasklets.tracker.proto import issue_create_tasklet


class IssueCreateImpl(UpdateProgressMixin, issue_create_tasklet.IssueCreateBase):
    def run(self):
        tracker_client = get_tracker_client(self.ctx.yav, self.input.config.tracker)

        kwargs = {
            'queue': self.input.config.queue
        }

        def supply_if_exists(key):
            value = getattr(self.input.config, key)
            if value:
                if key in ('followers', 'components', 'tags'):
                    value = list(value)
                kwargs[key] = value

        supply_if_exists('type')
        supply_if_exists('summary')
        supply_if_exists('description')
        supply_if_exists('assignee')
        supply_if_exists('followers')
        supply_if_exists('components')
        supply_if_exists('tags')

        issue = tracker_client.issues.create(**kwargs)
        self.output.issue.key = issue.key
        self.update_progress(
            'issue_create',
            module=ProgressModules.TRACKER,
            status=TaskletProgress.SUCCESSFUL,
            text='Issue created successfully',
            url=format_issue_url(issue.key, self.input.config.tracker.api_url)
        )
