from .tracker import (
    get_tracker_client,
)
from .common import (
    ProgressModules,
    TaskletProgress,
    UpdateProgressMixin,
)
from startrek_client.exceptions import NotFound
from startrek_client.exceptions import Forbidden
from intranet.d.tasklets.tracker.proto import issue_transition_tasklet


class IssueTransitionImpl(UpdateProgressMixin, issue_transition_tasklet.IssueTransitionBase):
    def run(self):
        tracker_client = get_tracker_client(self.ctx.yav, self.input.config.tracker)

        kwargs = {}
        if self.input.config.resolution:
            kwargs['resolution'] = self.input.config.resolution
        if self.input.config.comment:
            kwargs['comment'] = self.input.config.comment

        counter_success = 0
        for key in self.input.issues.keys:
            try:
                issue = tracker_client.issues[key]
                transition = issue.transitions[self.input.config.transition]
                transition.execute(**kwargs)
                counter_success += 1
            except NotFound:
                print('Transition does not exist for issue ' + key)
            except Forbidden:
                print('Access denied to issue ' + key)

        self.update_progress(
            'issue_transition',
            module=ProgressModules.TRACKER,
            status=TaskletProgress.SUCCESSFUL,
            text='Issue changed status successfully (' + str(counter_success) + '/'
                 + str(len(self.input.issues.keys)) + ')',
        )
