import typing

from startrek_client import Startrek
from startrek_client.settings import VERSION_V2 as VERSION
from tasklet.services.yav import YavAdapter

from intranet.d.tasklets.tracker.proto import tracker_pb2


# Форк от /arcadia/billing/tasklets/tracker
def get_tracker_client(yav: YavAdapter, config: tracker_pb2.Config) -> Startrek:
    kwargs = {
        'token': yav.get_secret(config.token).secret,
        'api_version': VERSION,
        'useragent': 'intranet.d.tasklets.tracker'
    }

    if config.api_url:
        kwargs['base_url'] = config.api_url

    if config.user_agent:
        kwargs['useragent'] = config.user_agent

    return Startrek(**kwargs)


def format_issue_url(issue_key, api_url: typing.Optional[str]) -> str:
    if api_url:
        base_url = api_url.replace('st-api', 'st', 1).rstrip('/')
    else:
        base_url = 'https://st.yandex-team.ru'
    return f'{base_url}/{issue_key}'
