import logging

import requests
from django.conf import settings
from django.core.exceptions import ImproperlyConfigured
from django.utils.functional import SimpleLazyObject

logger = logging.getLogger(__name__)


class DetectFaceClient:
    def __init__(self, url):
        self.session = requests.Session()
        self.headers = {"Content-Type": "application/json"}
        self.url = url

    def detect(self, image_url):
        response = self.session.post(
            url=self.url,
            data='{"image_url":"%s"}' % image_url,
            headers=self.headers,
            verify="/app/.postgres/root.crt",
        )
        response.raise_for_status()

        data = response.json()
        if data and isinstance(data, list):
            return data[0]
        return {}


def get_client():
    if not settings.DEFACE_URL:
        raise ImproperlyConfigured("Set the DEFACE_URL environment variable")

    return DetectFaceClient(url=settings.DEFACE_URL)


detect_face = SimpleLazyObject(lambda: get_client())
