from django.core.exceptions import ImproperlyConfigured
from django.utils.functional import SimpleLazyObject
from yandex_geocoder import Client

from .settings import YANDEX_GEOCODER_TOKEN


def get_client():
    if not YANDEX_GEOCODER_TOKEN:
        raise ImproperlyConfigured("Set the YANDEX_GEOCODER_TOKEN environment variable")

    return Client(api_key=YANDEX_GEOCODER_TOKEN)


geocoder = SimpleLazyObject(lambda: get_client())
