import logging

from django.core.management.base import BaseCommand

from photoalbum.files.models import Photo
from photoalbum.files.tasks import get_location

logger = logging.getLogger(__name__)


class Command(BaseCommand):
    help = "Вычисляют точную локацию по всем фото"

    def handle(self, *args, **kwargs):
        logger.info("Started loading location")
        for photo in Photo.objects.exclude(geo_coords="").filter(location__isnull=True):
            logger.info(f"{photo.path}\nmedia_id: {photo.resource_id}")
            get_location(photo.id)
        logger.info("Finished loading location")
