from django.core.management.base import BaseCommand

from photoalbum.files.models import MediaFile, Tag, create_tags


class Command(BaseCommand):
    help = "Обновляет существующие теги"

    def handle(self, *args, **kwargs):
        cached_tags = dict()
        Tag.objects.all().delete()
        for media in MediaFile.objects.all():
            new_tags = create_tags(media.path, cached_tags)
            if new_tags:
                media.tags.set(new_tags)
