import logging
from multiprocessing import cpu_count

from django.core.management.base import BaseCommand, CommandParser

from photoalbum.files.tasks import upload_files

logger = logging.getLogger(__name__)


class Command(BaseCommand):
    help = "Загружает удаленные файлы обратно на Я.Диск в несколько потоков"

    def add_arguments(self, parser: CommandParser) -> None:
        parser.add_argument("--threads", type=int, default=cpu_count())
        parser.add_argument("--path", type=str, default="")
        parser.add_argument("--min_size", type=int, default=0)
        parser.add_argument("--max_size", type=int, default=100000)

    def handle(self, *args, **options):
        kwargs = dict(
            threads=options["threads"],
            path=options["path"],
            min_size=options["min_size"],
            max_size=options["max_size"],
        )
        upload_files(**kwargs)
