from multiprocessing import cpu_count

from django.core.management.base import BaseCommand, CommandParser

from photoalbum.files.services import download_files


class Command(BaseCommand):
    help = "Скачивает фотографии/превью с Яндекс.Диска"

    def add_arguments(self, parser: CommandParser) -> None:
        parser.add_argument("--threads", type=int, default=cpu_count())
        parser.add_argument("--preview", action="store_true")
        parser.add_argument("--media_type", type=str, default=None)
        parser.add_argument("--force", action="store_true")
        parser.add_argument("--pk", type=int, default=None)
        parser.add_argument("--limit", type=int, default=None)
        parser.add_argument("--min_size", type=int, default=0)
        parser.add_argument("--max_size", type=int, default=100000)

    def handle(self, *args, **options):
        """
        Многопоточная загрузка файлов из базы данных в S3
        :return:
        """
        kwargs = dict(
            threads=options["threads"],
            preview=options["preview"],
            media_type=options["media_type"],
            force=options["force"],
            pk=options["pk"],
            limit=options["limit"],
            min_size=options["min_size"],
            max_size=options["max_size"],
        )
        download_files(**kwargs)
