from django.core.management.base import BaseCommand, CommandParser

from photoalbum.files.tasks import get_metadata


class Command(BaseCommand):
    help = "Скачивает метаинформацию по файлам из Яндекс Диска"

    def add_arguments(self, parser: CommandParser) -> None:
        parser.add_argument("--limit", type=int, default=1000)
        parser.add_argument("--offset", type=int, default=0)
        parser.add_argument("--force", action="store_true")
        parser.add_argument("--init_path", type=str, default="")

    def handle(self, *args, **options):
        """
        Поиск в ширину по всем файлам на Яндекс Диске и загрузка их метаданных
        :return:
        """
        kwargs = dict(
            limit=options["limit"],
            offset=options["offset"],
            force=options["force"],
            init_path=options["init_path"],
        )
        get_metadata(**kwargs)
