# Generated by Django 3.1.13 on 2021-10-20 10:51

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import photoalbum.files.models
from photoalbum.files.models import get_upload_path


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Photo",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "resource_id",
                    models.CharField(
                        blank=True,
                        help_text="Поле resource_id из Я.Диска",
                        max_length=255,
                        unique=True,
                        verbose_name="resource id",
                    ),
                ),
                (
                    "filename",
                    models.CharField(max_length=255, verbose_name="имя файла"),
                ),
                ("path", models.CharField(max_length=1024, verbose_name="путь")),
                (
                    "size",
                    models.PositiveBigIntegerField(default=0, verbose_name="размер"),
                ),
                ("exif", models.JSONField(default=dict, verbose_name="EXIF")),
                (
                    "geo_coords",
                    models.CharField(
                        max_length=255, null=True, verbose_name="гео-координаты"
                    ),
                ),
                (
                    "file",
                    models.ImageField(
                        blank=True,
                        null=True,
                        upload_to=get_upload_path,
                        verbose_name="файл",
                    ),
                ),
                (
                    "chksum",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="хеш сумма"
                    ),
                ),
                ("photo_date", models.DateTimeField(verbose_name="дата съёмки")),
                (
                    "preview",
                    models.ImageField(
                        blank=True,
                        max_length=1024,
                        null=True,
                        upload_to=photoalbum.files.models.get_preview_upload_path,
                        verbose_name="превью",
                    ),
                ),
            ],
            options={
                "verbose_name": "фото",
                "verbose_name_plural": "фото",
            },
        ),
        migrations.CreateModel(
            name="Tag",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(max_length=255, unique=True, verbose_name="тег"),
                ),
            ],
            options={
                "verbose_name": "тег",
                "verbose_name_plural": "теги",
            },
        ),
        migrations.CreateModel(
            name="Video",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "resource_id",
                    models.CharField(
                        blank=True,
                        help_text="Поле resource_id из Я.Диска",
                        max_length=255,
                        unique=True,
                        verbose_name="resource id",
                    ),
                ),
                (
                    "filename",
                    models.CharField(max_length=255, verbose_name="имя файла"),
                ),
                ("path", models.CharField(max_length=1024, verbose_name="путь")),
                (
                    "size",
                    models.PositiveBigIntegerField(default=0, verbose_name="размер"),
                ),
                ("exif", models.JSONField(default=dict, verbose_name="EXIF")),
                (
                    "file",
                    models.FileField(
                        blank=True,
                        null=True,
                        upload_to=get_upload_path,
                        verbose_name="файл",
                    ),
                ),
                (
                    "chksum",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="хеш сумма"
                    ),
                ),
                ("video_date", models.DateTimeField(verbose_name="дата съёмки")),
                ("tags", models.ManyToManyField(to="files.Tag", verbose_name="теги")),
            ],
            options={
                "verbose_name": "видео",
                "verbose_name_plural": "видео",
            },
        ),
        migrations.CreateModel(
            name="PhotoDuplicate",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                (
                    "chksum",
                    models.CharField(
                        blank=True, max_length=255, verbose_name="хеш сумма"
                    ),
                ),
                (
                    "duplicates",
                    models.ManyToManyField(to="files.Photo", verbose_name="дубликаты"),
                ),
                (
                    "original",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="фото",
                        to="files.photo",
                        verbose_name="оригинал фото",
                    ),
                ),
            ],
            options={
                "verbose_name": "фото дубликат",
                "verbose_name_plural": "фото дубликаты",
            },
        ),
        migrations.AddField(
            model_name="photo",
            name="tags",
            field=models.ManyToManyField(to="files.Tag", verbose_name="теги"),
        ),
        migrations.CreateModel(
            name="UserOnPhoto",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="modified",
                    ),
                ),
                ("login", models.CharField(max_length=255, verbose_name="логин")),
                (
                    "photo",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="files.photo",
                        verbose_name="фото",
                    ),
                ),
            ],
            options={
                "verbose_name": "пользователь на фото",
                "verbose_name_plural": "пользователи на фото",
                "unique_together": {("photo", "login")},
            },
        ),
    ]
